/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation;

import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.annotation.IAnnotationOutlet;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardAnnotationOutlet
implements IAnnotationOutlet {
    private Map<COSName, IAnnotationFactory> instances = new HashMap<COSName, IAnnotationFactory>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected StandardAnnotationOutlet() {
    }

    protected IAnnotationFactory[] findProviders() {
        ArrayList<IAnnotationFactory> arrayList = new ArrayList<IAnnotationFactory>();
        Iterator iterator = ProviderTools.providers(IAnnotationFactory.class);
        while (iterator.hasNext()) {
            try {
                arrayList.add((IAnnotationFactory)iterator.next());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList.toArray(new IAnnotationFactory[arrayList.size()]);
    }

    @Override
    public synchronized IAnnotationFactory[] getAnnotationFactories() {
        this.init();
        return this.instances.values().toArray(new IAnnotationFactory[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAnnotationFactory[] iAnnotationFactoryArray = this.findProviders();
        int n = 0;
        while (n < iAnnotationFactoryArray.length) {
            IAnnotationFactory iAnnotationFactory = iAnnotationFactoryArray[n];
            this.registerAnnotationFactory(iAnnotationFactory);
            ++n;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IAnnotationFactory lookupAnnotationFactory(COSName cOSName) {
        this.init();
        return this.instances.get(cOSName);
    }

    @Override
    public synchronized void registerAnnotationFactory(IAnnotationFactory iAnnotationFactory) {
        this.instances.put(iAnnotationFactory.getAnnotationType(), iAnnotationFactory);
    }

    public void setLookupProviders(boolean bl) {
        this.lookupProviders = bl;
    }

    @Override
    public synchronized void unregisterAnnotationFactory(IAnnotationFactory iAnnotationFactory) {
        this.instances.remove(iAnnotationFactory.getAnnotationType());
    }
}

