/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSDeviceFeatures;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDPostScript;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;

public abstract class CSDeviceFilter
implements ICSDevice,
ICSDeviceFeatures {
    private final ICSDevice device;
    private boolean supportsColorSpace = true;
    private boolean supportsExtendedState = true;
    private boolean supportsFont = true;
    private boolean supportsInlineImage = true;
    private boolean supportsPattern = true;
    private boolean supportsProperties = true;
    private boolean supportsShading = true;
    private boolean supportsXObject = true;

    public CSDeviceFilter(ICSDevice iCSDevice) {
        this.device = iCSDevice;
        if (iCSDevice instanceof ICSDeviceFeatures) {
            this.supportsColorSpace = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsColorSpace();
            this.supportsExtendedState = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsExtendedState();
            this.supportsFont = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsFont();
            this.supportsInlineImage = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsInlineImage();
            this.supportsPattern = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsPattern();
            this.supportsProperties = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsProperties();
            this.supportsShading = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsShading();
            this.supportsXObject = ((ICSDeviceFeatures)((Object)iCSDevice)).supportsXObject();
        }
    }

    @Override
    public void close() {
        this.getDevice().close();
    }

    @Override
    public void compatibilityBegin() {
        this.getDevice().compatibilityBegin();
    }

    @Override
    public void compatibilityEnd() {
        this.getDevice().compatibilityEnd();
    }

    protected void doForm(COSName cOSName, PDForm pDForm) throws CSException {
        this.saveState();
        try {
            CDSMatrix cDSMatrix = pDForm.getMatrix();
            if (cDSMatrix != null) {
                this.transform(cDSMatrix.getA(), cDSMatrix.getB(), cDSMatrix.getC(), cDSMatrix.getD(), cDSMatrix.getE(), cDSMatrix.getF());
            }
            CDSRectangle cDSRectangle = pDForm.getBoundingBox();
            if (this.getInterpreter() != null) {
                this.getInterpreter().process(pDForm.getContentStream(), pDForm.getResources());
            }
        }
        finally {
            this.restoreState();
        }
    }

    protected void doImage(COSName cOSName, PDImage pDImage) throws CSException {
        this.getDevice().doXObject(cOSName, pDImage);
    }

    protected void doPostScript(COSName cOSName, PDPostScript pDPostScript) throws CSException {
    }

    @Override
    public void doShading(COSName cOSName, PDShading pDShading) {
        this.getDevice().doShading(cOSName, pDShading);
    }

    @Override
    public void doXObject(COSName cOSName, PDXObject pDXObject) {
        if (pDXObject == null) {
            return;
        }
        if (pDXObject.isForm()) {
            try {
                this.doForm(cOSName, (PDForm)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering form", exception);
            }
        } else if (pDXObject.isImage()) {
            try {
                this.doImage(cOSName, (PDImage)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering image", exception);
            }
        } else if (pDXObject.isPostscript()) {
            try {
                this.doPostScript(cOSName, (PDPostScript)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering postscript", exception);
            }
        } else {
            throw new CSNotSupported("unknown XObject type");
        }
    }

    public ICSDevice getDevice() {
        return this.device;
    }

    @Override
    public GraphicsState getGraphicsState() {
        return this.getDevice().getGraphicsState();
    }

    @Override
    public ICSInterpreter getInterpreter() {
        return this.getDevice().getInterpreter();
    }

    @Override
    public void inlineImage(PDImage pDImage) {
        this.getDevice().inlineImage(pDImage);
    }

    @Override
    public void markedContentBegin(COSName cOSName) {
        this.getDevice().markedContentBegin(cOSName);
    }

    @Override
    public void markedContentBeginProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
        this.getDevice().markedContentBeginProperties(cOSName, cOSName2, cOSDictionary);
    }

    @Override
    public void markedContentEnd() {
        this.getDevice().markedContentEnd();
    }

    @Override
    public void markedContentPoint(COSName cOSName) {
        this.getDevice().markedContentPoint(cOSName);
    }

    @Override
    public void markedContentPointProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
        this.getDevice().markedContentPointProperties(cOSName, cOSName2, cOSDictionary);
    }

    @Override
    public void open(ICSInterpreter iCSInterpreter) {
        this.getDevice().open(iCSInterpreter);
    }

    @Override
    public void pathClipEvenOdd() {
        this.getDevice().pathClipEvenOdd();
    }

    @Override
    public void pathClipNonZero() {
        this.getDevice().pathClipNonZero();
    }

    @Override
    public void pathClose() {
        this.getDevice().pathClose();
    }

    @Override
    public void pathCloseFillStrokeEvenOdd() {
        this.getDevice().pathCloseFillStrokeEvenOdd();
    }

    @Override
    public void pathCloseFillStrokeNonZero() {
        this.getDevice().pathCloseFillStrokeNonZero();
    }

    @Override
    public void pathCloseStroke() {
        this.getDevice().pathCloseStroke();
    }

    @Override
    public void pathEnd() {
        this.getDevice().pathEnd();
    }

    @Override
    public void pathFillEvenOdd() {
        this.getDevice().pathFillEvenOdd();
    }

    @Override
    public void pathFillNonZero() {
        this.getDevice().pathFillNonZero();
    }

    @Override
    public void pathFillStrokeEvenOdd() {
        this.getDevice().pathFillStrokeEvenOdd();
    }

    @Override
    public void pathFillStrokeNonZero() {
        this.getDevice().pathFillStrokeNonZero();
    }

    @Override
    public void pathStroke() {
        this.getDevice().pathStroke();
    }

    @Override
    public void penCurveToC(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().penCurveToC(f, f2, f3, f4, f5, f6);
    }

    @Override
    public void penCurveToV(float f, float f2, float f3, float f4) {
        this.getDevice().penCurveToV(f, f2, f3, f4);
    }

    @Override
    public void penCurveToY(float f, float f2, float f3, float f4) {
        this.getDevice().penCurveToY(f, f2, f3, f4);
    }

    @Override
    public void penLineTo(float f, float f2) {
        this.getDevice().penLineTo(f, f2);
    }

    @Override
    public void penMoveTo(float f, float f2) {
        this.getDevice().penMoveTo(f, f2);
    }

    @Override
    public void penRectangle(float f, float f2, float f3, float f4) {
        this.getDevice().penRectangle(f, f2, f3, f4);
    }

    @Override
    public void restoreState() {
        this.getDevice().restoreState();
    }

    @Override
    public void saveState() {
        this.getDevice().saveState();
    }

    @Override
    public void setExtendedState(COSName cOSName, PDExtGState pDExtGState) {
        this.getDevice().setExtendedState(cOSName, pDExtGState);
    }

    @Override
    public void setFlatnessTolerance(float f) {
        this.getDevice().setFlatnessTolerance(f);
    }

    @Override
    public void setLineCap(int n) {
        this.getDevice().setLineCap(n);
    }

    @Override
    public void setLineDash(float[] fArray, float f) {
        this.getDevice().setLineDash(fArray, f);
    }

    @Override
    public void setLineJoin(int n) {
        this.getDevice().setLineJoin(n);
    }

    @Override
    public void setLineWidth(float f) {
        this.getDevice().setLineWidth(f);
    }

    @Override
    public void setMiterLimit(float f) {
        this.getDevice().setMiterLimit(f);
    }

    @Override
    public void setNonStrokeColorCMYK(float f, float f2, float f3, float f4) {
        this.getDevice().setNonStrokeColorCMYK(f, f2, f3, f4);
    }

    @Override
    public void setNonStrokeColorGray(float f) {
        this.getDevice().setNonStrokeColorGray(f);
    }

    @Override
    public void setNonStrokeColorRGB(float f, float f2, float f3) {
        this.getDevice().setNonStrokeColorRGB(f, f2, f3);
    }

    @Override
    public void setNonStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        this.getDevice().setNonStrokeColorSpace(cOSName, pDColorSpace);
    }

    @Override
    public void setNonStrokeColorValues(float[] fArray) {
        this.getDevice().setNonStrokeColorValues(fArray);
    }

    @Override
    public void setNonStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.getDevice().setNonStrokeColorValues(fArray, cOSName, pDPattern);
    }

    @Override
    public void setRenderingIntent(COSName cOSName) {
        this.getDevice().setRenderingIntent(cOSName);
    }

    @Override
    public void setStrokeColorCMYK(float f, float f2, float f3, float f4) {
        this.getDevice().setStrokeColorCMYK(f, f2, f3, f4);
    }

    @Override
    public void setStrokeColorGray(float f) {
        this.getDevice().setStrokeColorGray(f);
    }

    @Override
    public void setStrokeColorRGB(float f, float f2, float f3) {
        this.getDevice().setStrokeColorRGB(f, f2, f3);
    }

    @Override
    public void setStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        this.getDevice().setStrokeColorSpace(cOSName, pDColorSpace);
    }

    @Override
    public void setStrokeColorValues(float[] fArray) {
        this.getDevice().setStrokeColorValues(fArray);
    }

    @Override
    public void setStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.getDevice().setStrokeColorValues(fArray, cOSName, pDPattern);
    }

    @Override
    public boolean supportsColorSpace() {
        return this.supportsColorSpace;
    }

    @Override
    public boolean supportsExtendedState() {
        return this.supportsExtendedState;
    }

    @Override
    public boolean supportsFont() {
        return this.supportsFont;
    }

    @Override
    public boolean supportsInlineImage() {
        return this.supportsInlineImage;
    }

    @Override
    public boolean supportsPattern() {
        return this.supportsPattern;
    }

    @Override
    public boolean supportsProperties() {
        return this.supportsProperties;
    }

    @Override
    public boolean supportsShading() {
        return this.supportsShading;
    }

    @Override
    public boolean supportsXObject() {
        return this.supportsXObject;
    }

    @Override
    public void textBegin() {
        this.getDevice().textBegin();
    }

    @Override
    public void textEnd() {
        this.getDevice().textEnd();
    }

    @Override
    public void textLineMove(float f, float f2) {
        this.getDevice().textLineMove(f, f2);
    }

    @Override
    public void textLineNew() {
        this.getDevice().textLineNew();
    }

    @Override
    public void textMove(float f, float f2) {
        this.getDevice().textMove(f, f2);
    }

    @Override
    public void textMoveTo(float f, float f2) {
        this.getDevice().textMoveTo(f, f2);
    }

    @Override
    public void textSetCharSpacing(float f) {
        this.getDevice().textSetCharSpacing(f);
    }

    @Override
    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        this.getDevice().textSetFont(cOSName, pDFont, f);
    }

    @Override
    public void textSetHorizontalScaling(float f) {
        this.getDevice().textSetHorizontalScaling(f);
    }

    @Override
    public void textSetLeading(float f) {
        this.getDevice().textSetLeading(f);
    }

    @Override
    public void textSetRenderingMode(int n) {
        this.getDevice().textSetRenderingMode(n);
    }

    @Override
    public void textSetRise(float f) {
        this.getDevice().textSetRise(f);
    }

    @Override
    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().textSetTransform(f, f2, f3, f4, f5, f6);
    }

    @Override
    public void textSetWordSpacing(float f) {
        this.getDevice().textSetWordSpacing(f);
    }

    @Override
    public void textShow(byte[] byArray, int n, int n2) {
        this.getDevice().textShow(byArray, n, n2);
    }

    @Override
    public void textShow(char[] cArray, int n, int n2) {
        this.getDevice().textShow(cArray, n, n2);
    }

    @Override
    public void textShow(String string) {
        this.getDevice().textShow(string);
    }

    @Override
    public void textT3SetGlyphWidth(float f, float f2) {
        this.getDevice().textT3SetGlyphWidth(f, f2);
    }

    @Override
    public void textT3SetGlyphWidthBB(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().textT3SetGlyphWidthBB(f, f2, f3, f4, f5, f6);
    }

    @Override
    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.getDevice().transform(f, f2, f3, f4, f5, f6);
    }
}

