/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CIDToGIDMap;

public class CIDFontType2
extends CIDFont {
    public static final MetaClass META = new MetaClass((Class)MetaClass.class.getDeclaringClass());
    public static final COSName DK_CIDToGIDMap = COSName.constant("CIDToGIDMap");
    private byte[] mappingTable;

    public CIDFontType2(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSObject cosGetCIDToGIDMap() {
        return this.cosGetField(DK_CIDToGIDMap);
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_CIDFontType2;
    }

    @Override
    public String getFontType() {
        return "TrueType";
    }

    @Override
    public int getGlyphIndex(int n) {
        int n2;
        if (this.mappingTable == null) {
            COSObject cOSObject = this.cosGetCIDToGIDMap();
            if (cOSObject.isNull() || cOSObject instanceof COSName) {
                return n;
            }
            this.mappingTable = ((COSStream)cOSObject).getDecodedBytes();
        }
        int n3 = n << 1;
        try {
            n2 = this.mappingTable[n3] & 0xFF;
            n2 = (n2 << 8) + (this.mappingTable[n3 + 1] & 0xFF);
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
        return n2;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_CIDToGIDMap, CIDToGIDMap.CN_Identity);
    }

    public static class MetaClass
    extends CIDFont.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new CIDFontType2(cOSObject);
        }
    }
}

