/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid.refine;

import boofcv.alg.feature.detect.grid.RefineCalibrationGridCorner;
import boofcv.alg.feature.detect.grid.refine.RefineCornerSegmentFit;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class WrapRefineCornerSegmentFit
implements RefineCalibrationGridCorner {
    RefineCornerSegmentFit alg = new RefineCornerSegmentFit();

    @Override
    public void refine(List<QuadBlob> squares, ImageFloat32 image) {
        for (QuadBlob s : squares) {
            int searchRadius = (int)s.smallestSide - 2;
            if (searchRadius > 15) {
                searchRadius = 15;
            }
            if (searchRadius < 3) {
                searchRadius = 3;
            }
            for (int i = 0; i < 4; ++i) {
                Point2D_I32 cp = s.corners.get(i);
                Point2D_F64 rp = s.subpixel.get(i);
                ImageRectangle r = new ImageRectangle(cp.x - searchRadius, cp.y - searchRadius, cp.x + searchRadius + 1, cp.y + searchRadius + 1);
                BoofMiscOps.boundRectangleInside((ImageBase)image, (ImageRectangle)r);
                ImageFloat32 sub = (ImageFloat32)image.subimage(r.x0, r.y0, r.x1, r.y1, null);
                this.alg.process(sub);
                rp.x = (float)r.x0 + (float)this.alg.getCorner().x;
                rp.y = (float)r.y0 + (float)this.alg.getCorner().y;
            }
        }
    }
}

