/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta.thresholding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.measure.ExampleBasedBipartitionMeasureBase;
import mulan.evaluation.measure.HammingLoss;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.TechnicalInformation;

public class MLPTO
extends MultiLabelMetaLearner {
    private ExampleBasedBipartitionMeasureBase EBBM;

    public MLPTO() {
        this(new BinaryRelevance((Classifier)new J48()), new HammingLoss());
    }

    public MLPTO(MultiLabelLearner baseLearner, ExampleBasedBipartitionMeasureBase EBBM) {
        super(baseLearner);
        this.EBBM = EBBM;
    }

    private int OptimizeFLoss(double[] orderedProbabilities, ExampleBasedBipartitionMeasureBase EBBM) throws Exception {
        double P;
        int L = orderedProbabilities.length;
        double[][] Pc = new double[L + 2][L + 1];
        for (int a = -2; a < L; ++a) {
            for (int From = L; From >= 0; --From) {
                P = a == -2 ? 0.0 : (From == L - 1 && a == -1 ? 1.0 - orderedProbabilities[L - 1] : (From == L - 1 && a == 0 ? orderedProbabilities[L - 1] : (a + 1 > L - From ? 0.0 : (From == L && a == -1 ? 1.0 : orderedProbabilities[From] * Pc[a + 2 - 1][From + 1] + (1.0 - orderedProbabilities[From]) * Pc[a + 2][From + 1]))));
                Pc[a + 2][From] = P;
            }
        }
        double[][] Pa = new double[L + 2][L];
        for (int a = -2; a < L; ++a) {
            for (int To = 0; To < L; ++To) {
                P = a == -2 ? 0.0 : (To == 0 && a == -1 ? 1.0 - orderedProbabilities[0] : (To == 0 && a == 0 ? orderedProbabilities[0] : (a > To - 1 + 1 ? 0.0 : orderedProbabilities[To] * Pa[a + 2 - 1][To - 1] + (1.0 - orderedProbabilities[To]) * Pa[a + 2][To - 1])));
                Pa[a + 2][To] = P;
            }
        }
        int BestR = 0;
        double BestLoss = Double.POSITIVE_INFINITY;
        for (int R = 1; R <= L; ++R) {
            double TotalMeasure = 0.0;
            for (int a = 0; a <= R; ++a) {
                int b = R - a;
                for (int c = 0; c <= L - R; ++c) {
                    double TheMeasure = Math.abs(EBBM.getIdealValue() - this.CalculateMeasure(EBBM, a, b, c, L));
                    double TheMeasure1 = TheMeasure * Pc[c + 1][R] * Pa[a + 1][R - 1];
                    TotalMeasure += TheMeasure1;
                }
            }
            if (!(BestLoss > TotalMeasure)) continue;
            BestLoss = TotalMeasure;
            BestR = R;
        }
        int NLabels = BestR;
        return NLabels;
    }

    private double CalculateMeasure(ExampleBasedBipartitionMeasureBase EBBM, int a, int b, int c, int L) {
        int i;
        boolean[] bipartition = new boolean[L];
        boolean[] truth = new boolean[L];
        int p = 0;
        for (i = 0; i < a; ++i) {
            bipartition[p] = true;
            truth[p] = true;
            ++p;
        }
        for (i = 0; i < b; ++i) {
            bipartition[p] = true;
            truth[p] = false;
            ++p;
        }
        for (i = 0; i < c; ++i) {
            bipartition[p] = false;
            truth[p] = true;
            ++p;
        }
        for (i = 0; i < L - a - b - c; ++i) {
            bipartition[p] = false;
            truth[p] = false;
            ++p;
        }
        MultiLabelOutput MLO = new MultiLabelOutput(bipartition);
        EBBM.update(MLO, truth);
        double val = EBBM.getValue();
        EBBM.reset();
        return val;
    }

    private double calculateThreshold(double[] confidences) throws Exception {
        double[] orderedConfidences = this.sort(confidences);
        int NLabels = this.OptimizeFLoss(orderedConfidences, this.EBBM);
        double newThreshold = NLabels == orderedConfidences.length ? (orderedConfidences[NLabels - 1] + 0.0) / 2.0 : (orderedConfidences[NLabels - 1] + orderedConfidences[Math.min(NLabels, orderedConfidences.length - 1)]) / 2.0;
        return newThreshold;
    }

    private double[] sort(double[] vector) {
        ArrayList<Double> array = new ArrayList<Double>();
        Comparator comparator = Collections.reverseOrder();
        for (int i = 0; i < vector.length; ++i) {
            array.add(vector[i]);
        }
        Collections.sort(array, comparator);
        double[] orderedVector = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            orderedVector[i] = (Double)array.get(i);
        }
        return orderedVector;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingData) throws Exception {
        this.baseLearner.build(trainingData);
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        MultiLabelOutput mlo = this.baseLearner.makePrediction(instance);
        double[] confidences = mlo.getConfidences();
        double threshold = this.calculateThreshold(confidences);
        boolean[] predictedLabels = new boolean[this.numLabels];
        for (int i = 0; i < this.numLabels; ++i) {
            predictedLabels[i] = confidences[i] >= threshold;
        }
        MultiLabelOutput newOutput = new MultiLabelOutput(predictedLabels, mlo.getConfidences());
        return newOutput;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J.R. Quevedo and O. Luaces and A. Bahamonde");
        result.setValue(TechnicalInformation.Field.TITLE, "Multilabel classifiers with a probabilistic thresholding strategy");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Recognition");
        result.setValue(TechnicalInformation.Field.VOLUME, "45");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.YEAR, "2012");
        result.setValue(TechnicalInformation.Field.ISSN, "0031-3203");
        result.setValue(TechnicalInformation.Field.PAGES, "876-883");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Elsevier");
        return result;
    }

    @Override
    public String globalInfo() {
        return "Class that implements the Multi Label Probabilistic Threshold Optimizer (MLTPTO). For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

