/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.neural;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mulan.core.ArgumentNullException;
import mulan.data.MultiLabelInstances;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class DataPair {
    private final double[] input;
    private final double[] output;
    private boolean[] outputBoolean;

    public DataPair(double[] inputPattern, double[] trueOutput) {
        if (inputPattern == null) {
            throw new ArgumentNullException("inputPattern");
        }
        if (trueOutput == null) {
            throw new ArgumentNullException("trueOutput");
        }
        this.input = Arrays.copyOf(inputPattern, inputPattern.length);
        this.output = Arrays.copyOf(trueOutput, trueOutput.length);
    }

    public double[] getInput() {
        return this.input;
    }

    public double[] getOutput() {
        return this.output;
    }

    public boolean[] getOutputBoolean() {
        if (this.outputBoolean == null) {
            this.outputBoolean = new boolean[this.output.length];
            for (int i = 0; i < this.output.length; ++i) {
                this.outputBoolean[i] = this.output[i] == 1.0;
            }
        }
        return this.outputBoolean;
    }

    public static List<DataPair> createDataPairs(MultiLabelInstances mlDataSet, boolean bipolarOutput) {
        Instances data = mlDataSet.getDataSet();
        int[] featureIndices = mlDataSet.getFeatureIndices();
        int[] labelIndices = mlDataSet.getLabelIndices();
        int numFeatures = featureIndices.length;
        int numLabels = mlDataSet.getNumLabels();
        int numInstances = data.numInstances();
        ArrayList<DataPair> dataPairs = new ArrayList<DataPair>(numInstances);
        for (int index = 0; index < numInstances; ++index) {
            Instance instance = data.instance(index);
            double[] input = new double[numFeatures];
            for (int i = 0; i < numFeatures; ++i) {
                int featureIndex = featureIndices[i];
                Attribute featureAttr = instance.attribute(featureIndex);
                input[i] = featureAttr.isNominal() && featureAttr.numValues() == 2 ? Double.parseDouble(instance.stringValue(featureIndex)) : instance.value(featureIndex);
            }
            if (mlDataSet.hasMissingLabels(instance)) continue;
            double[] output = new double[numLabels];
            for (int i = 0; i < numLabels; ++i) {
                output[i] = Double.parseDouble(data.attribute(labelIndices[i]).value((int)instance.value(labelIndices[i])));
                if (!bipolarOutput || output[i] != 0.0) continue;
                output[i] = -1.0;
            }
            dataPairs.add(new DataPair(input, output));
        }
        return dataPairs;
    }
}

