/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.neural;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mulan.classifier.neural.DataPair;
import mulan.classifier.neural.MMPUpdateRuleBase;
import mulan.classifier.neural.model.Neuron;
import mulan.evaluation.loss.RankingLossFunction;

public class MMPUniformUpdateRule
extends MMPUpdateRuleBase {
    public MMPUniformUpdateRule(List<Neuron> perceptrons, RankingLossFunction lossMeasure) {
        super(perceptrons, lossMeasure);
    }

    @Override
    protected double[] computeUpdateParameters(DataPair example, double[] confidences, double loss) {
        int numLabels = example.getOutput().length;
        boolean[] trueOutput = example.getOutputBoolean();
        HashSet<Integer> relevant = new HashSet<Integer>();
        HashSet<Integer> irrelevant = new HashSet<Integer>();
        for (int index = 0; index < numLabels; ++index) {
            if (trueOutput[index]) {
                relevant.add(index);
                continue;
            }
            irrelevant.add(index);
        }
        int setCount = 0;
        double[] params = new double[numLabels];
        Iterator i$ = relevant.iterator();
        while (i$.hasNext()) {
            int rLabel = (Integer)i$.next();
            Iterator i$2 = irrelevant.iterator();
            while (i$2.hasNext()) {
                int irLabel = (Integer)i$2.next();
                if (!(confidences[rLabel] <= confidences[irLabel])) continue;
                int n = rLabel;
                params[n] = params[n] + 1.0;
                int n2 = irLabel;
                params[n2] = params[n2] - 1.0;
                ++setCount;
            }
        }
        for (int index = 0; index < numLabels; ++index) {
            if (params[index] == 0.0) continue;
            int n = index;
            params[n] = params[n] * (loss / (double)setCount);
        }
        return params;
    }
}

