/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class ConverterCLUS {
    public static void convert(String sourceFilename, String arffFilename, String xmlFilename) throws Exception {
        try {
            int i;
            String line;
            BufferedReader brInput = new BufferedReader(new FileReader(sourceFilename));
            String relationName = null;
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
            Instances data = null;
            int numAttributes = 0;
            String[] labelNames = null;
            while ((line = brInput.readLine()) != null) {
                String[] tokens;
                if (line.startsWith("@RELATION")) {
                    relationName = line.replace("@RELATION ", "").replaceAll("'", "").trim();
                    continue;
                }
                if (line.startsWith("@ATTRIBUTE ")) {
                    Attribute att;
                    tokens = line.split("\\s+");
                    if (line.startsWith("@ATTRIBUTE class")) {
                        labelNames = tokens[3].split(",");
                        for (i = 0; i < labelNames.length; ++i) {
                            ArrayList<String> labelValues = new ArrayList<String>();
                            labelValues.add("0");
                            labelValues.add("1");
                            att = new Attribute(labelNames[i], labelValues);
                            attInfo.add(att);
                        }
                        continue;
                    }
                    ++numAttributes;
                    if (tokens[2].equals("numeric")) {
                        att = new Attribute(tokens[1]);
                    } else {
                        ArrayList<String> nominalValues = new ArrayList<String>();
                        tokens[2].substring(1, tokens[2].length() - 1);
                        String[] nominalTokens = tokens[2].substring(1, tokens[2].length() - 1).split(",");
                        nominalValues.addAll(Arrays.asList(nominalTokens));
                        att = new Attribute(tokens[1], nominalValues);
                    }
                    attInfo.add(att);
                    continue;
                }
                if (!line.toLowerCase().startsWith("@data")) continue;
                data = new Instances(relationName, attInfo, 0);
                while ((line = brInput.readLine()) != null) {
                    tokens = line.split(",");
                    double[] values = new double[attInfo.size()];
                    for (int i2 = 0; i2 < numAttributes; ++i2) {
                        Attribute att = (Attribute)attInfo.get(i2);
                        values[i2] = att.isNumeric() ? Double.parseDouble(tokens[i2]) : (double)att.indexOfValue(tokens[i2]);
                    }
                    String[] labels = tokens[numAttributes].split("@");
                    for (int j = 0; j < labels.length; ++j) {
                        String[] splitedLabels = labels[j].split("/");
                        String attrName = splitedLabels[0];
                        Attribute att = data.attribute(attrName);
                        values[attInfo.indexOf((Object)att)] = 1.0;
                        for (int k = 1; k < splitedLabels.length; ++k) {
                            attrName = attrName + "/" + splitedLabels[k];
                            att = data.attribute(attrName);
                            values[attInfo.indexOf((Object)att)] = 1.0;
                        }
                    }
                    DenseInstance instance = new DenseInstance(1.0, values);
                    data.add((Instance)instance);
                }
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(arffFilename));
            writer.write(data.toString());
            writer.close();
            writer = new BufferedWriter(new FileWriter(xmlFilename));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            writer.write("<labels xmlns=\"http://mulan.sourceforge.net/labels\">\n");
            writer.write("<label name=\"" + labelNames[0] + "\">");
            int depth = 0;
            for (i = 1; i < labelNames.length; ++i) {
                int j;
                int difSlashes = ConverterCLUS.countSlashes(labelNames[i]) - ConverterCLUS.countSlashes(labelNames[i - 1]);
                if (difSlashes == 1) {
                    ++depth;
                    writer.write("\n");
                    for (j = 0; j < depth; ++j) {
                        writer.write("\t");
                    }
                    writer.write("<label name=\"" + labelNames[i] + "\">");
                }
                if (difSlashes == 0) {
                    writer.write("</label>\n");
                    for (j = 0; j < depth; ++j) {
                        writer.write("\t");
                    }
                    writer.write("<label name=\"" + labelNames[i] + "\">");
                }
                if (difSlashes >= 0) continue;
                writer.write("</label>\n");
                for (j = 0; j < Math.abs(difSlashes); ++j) {
                    --depth;
                    for (int k = 0; k < depth; ++k) {
                        writer.write("\t");
                    }
                    writer.write("</label>\n");
                }
                for (j = 0; j < depth; ++j) {
                    writer.write("\t");
                }
                writer.write("<label name=\"" + labelNames[i] + "\">");
            }
            writer.write("</label>\n");
            while (depth > 0) {
                for (int k = 0; k < depth; ++k) {
                    writer.write("\t");
                }
                writer.write("</label>\n");
                --depth;
            }
            writer.write("</labels>");
            writer.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    private static int countSlashes(String label) {
        int counter = 0;
        for (int i = 0; i < label.length(); ++i) {
            if (label.charAt(i) != '/') continue;
            ++counter;
        }
        return counter;
    }
}

