/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.data.MultiLabelInstances;
import mulan.data.Stratification;
import mulan.transformations.LabelPowersetTransformation;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class LabelPowersetStratification
implements Stratification,
TechnicalInformationHandler {
    private int seed;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.CONFERENCE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Sechidis, Konstantinos and Tsoumakas, Grigorios and Vlahavas, Ioannis");
        result.setValue(TechnicalInformation.Field.TITLE, "On the stratification of multi-label data");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 2011 European conference on Machine learning and knowledge discovery in databases - Volume Part III");
        result.setValue(TechnicalInformation.Field.SERIES, "ECML PKDD'11");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.ISBN, "978-3-642-23807-9");
        result.setValue(TechnicalInformation.Field.LOCATION, "Athens, Greece");
        result.setValue(TechnicalInformation.Field.PAGES, "145--158");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer-Verlag");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Berlin, Heidelberg");
        return result;
    }

    public LabelPowersetStratification() {
        this.seed = 0;
    }

    public LabelPowersetStratification(int aSeed) {
        this.seed = aSeed;
    }

    @Override
    public MultiLabelInstances[] stratify(MultiLabelInstances data, int folds) {
        try {
            int i;
            MultiLabelInstances[] segments = new MultiLabelInstances[folds];
            LabelPowersetTransformation transformation = new LabelPowersetTransformation();
            Instances transformed = transformation.transformInstances(data);
            Add add = new Add();
            add.setAttributeIndex("first");
            add.setAttributeName("instanceID");
            add.setInputFormat(transformed);
            transformed = Filter.useFilter((Instances)transformed, (Filter)add);
            for (i = 0; i < transformed.numInstances(); ++i) {
                transformed.instance(i).setValue(0, (double)i);
            }
            transformed.setClassIndex(transformed.numAttributes() - 1);
            transformed.randomize(new Random(this.seed));
            transformed.stratify(folds);
            for (i = 0; i < folds; ++i) {
                Instances temp = transformed.testCV(folds, i);
                Instances test = new Instances(data.getDataSet(), 0);
                for (int j = 0; j < temp.numInstances(); ++j) {
                    test.add(data.getDataSet().instance((int)temp.instance(j).value(0)));
                }
                segments[i] = new MultiLabelInstances(test, data.getLabelsMetaData());
            }
            return segments;
        }
        catch (Exception ex) {
            Logger.getLogger(LabelPowersetStratification.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

