/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mulan.core.ArgumentNullException;
import mulan.core.MulanRuntimeException;
import mulan.data.DataLoadException;
import mulan.data.InvalidDataFormatException;
import mulan.data.LabelNode;
import mulan.data.LabelNodeImpl;
import mulan.data.LabelsBuilder;
import mulan.data.LabelsBuilderException;
import mulan.data.LabelsMetaData;
import mulan.data.LabelsMetaDataImpl;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class MultiLabelInstances
implements Serializable {
    private Instances dataSet;
    private final LabelsMetaData labelsMetaData;

    public MultiLabelInstances(String arffFilePath, int numLabelAttributes) throws InvalidDataFormatException {
        if (arffFilePath == null) {
            throw new ArgumentNullException("arffFilePath");
        }
        if (numLabelAttributes < 2) {
            throw new IllegalArgumentException("The number of label attributes must me at least 2 or higher.");
        }
        File arffFile = new File(arffFilePath);
        Instances data = this.loadInstances(arffFile);
        LabelsMetaData labelsData = this.loadLabesMeta(data, numLabelAttributes);
        this.validate(data, labelsData);
        this.dataSet = data;
        this.labelsMetaData = labelsData;
    }

    public MultiLabelInstances(InputStream arffDataStream, int numLabelAttributes) throws InvalidDataFormatException {
        if (arffDataStream == null) {
            throw new ArgumentNullException("arffDataStream");
        }
        if (numLabelAttributes < 2) {
            throw new IllegalArgumentException("The number of label attributes must me at least 2 or higher.");
        }
        Instances data = this.loadInstances(arffDataStream);
        LabelsMetaData labelsData = this.loadLabesMeta(data, numLabelAttributes);
        this.validate(data, labelsData);
        this.dataSet = data;
        this.labelsMetaData = labelsData;
    }

    public MultiLabelInstances(Instances data, String xmlLabelsDefFilePath) throws InvalidDataFormatException {
        if (xmlLabelsDefFilePath == null) {
            throw new ArgumentNullException("xmlLabelsDefFilePath");
        }
        LabelsMetaData labelsData = this.loadLabesMeta(xmlLabelsDefFilePath);
        this.validate(data, labelsData);
        this.dataSet = data;
        this.labelsMetaData = labelsData;
    }

    public MultiLabelInstances(String arffFilePath, String xmlLabelsDefFilePath) throws InvalidDataFormatException {
        if (arffFilePath == null) {
            throw new ArgumentNullException("arffFilePath");
        }
        if (xmlLabelsDefFilePath == null) {
            throw new ArgumentNullException("xmlLabelsDefFilePath");
        }
        File arffFile = new File(arffFilePath);
        Instances data = this.loadInstances(arffFile);
        LabelsMetaData labelsData = this.loadLabesMeta(xmlLabelsDefFilePath);
        this.validate(data, labelsData);
        this.dataSet = data;
        this.labelsMetaData = labelsData;
    }

    public MultiLabelInstances(InputStream arffDataStream, InputStream xmlLabelsDefStream) throws InvalidDataFormatException {
        if (arffDataStream == null) {
            throw new ArgumentNullException("arffDataStream");
        }
        if (xmlLabelsDefStream == null) {
            throw new ArgumentNullException("xmlLabelsDefStream");
        }
        Instances data = this.loadInstances(arffDataStream);
        LabelsMetaData labelsData = this.loadLabesMeta(xmlLabelsDefStream);
        this.validate(data, labelsData);
        this.dataSet = data;
        this.labelsMetaData = labelsData;
    }

    public MultiLabelInstances(Instances dataSet, LabelsMetaData labelsMetaData) throws InvalidDataFormatException {
        if (dataSet == null) {
            throw new ArgumentNullException("dataSet");
        }
        if (labelsMetaData == null) {
            throw new ArgumentNullException("labelsMetaData");
        }
        this.validate(dataSet, labelsMetaData);
        this.dataSet = dataSet;
        this.labelsMetaData = labelsMetaData;
    }

    public int getNumLabels() {
        return this.labelsMetaData.getNumLabels();
    }

    public int getNumInstances() {
        return this.dataSet.numInstances();
    }

    public double getCardinality() {
        double labelCardinality = 0.0;
        int numInstances = this.dataSet.numInstances();
        int numLabels = this.labelsMetaData.getNumLabels();
        int[] labelIndices = this.getLabelIndices();
        for (int i = 0; i < numInstances; ++i) {
            for (int j = 0; j < numLabels; ++j) {
                if (!this.dataSet.instance(i).stringValue(labelIndices[j]).equals("1")) continue;
                labelCardinality += 1.0;
            }
        }
        return labelCardinality /= (double)numInstances;
    }

    public int[] getLabelIndices() {
        int[] labelIndices = new int[this.labelsMetaData.getNumLabels()];
        int numAttributes = this.dataSet.numAttributes();
        Set<String> labelNames = this.labelsMetaData.getLabelNames();
        int counter = 0;
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (!labelNames.contains(attr.name())) continue;
            labelIndices[counter] = index;
            ++counter;
        }
        return labelIndices;
    }

    public Map<String, Integer> getLabelsOrder() {
        int numAttributes = this.dataSet.numAttributes();
        Set<String> labelNames = this.labelsMetaData.getLabelNames();
        HashMap<String, Integer> assoc = new HashMap<String, Integer>();
        int counter = 0;
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (!labelNames.contains(attr.name())) continue;
            assoc.put(attr.name(), counter);
            ++counter;
        }
        return assoc;
    }

    public Set<Attribute> getLabelAttributes() {
        Set<String> labelNames = this.labelsMetaData.getLabelNames();
        HashSet<Attribute> labelAttributes = new HashSet<Attribute>(this.getNumLabels());
        int numAttributes = this.dataSet.numAttributes();
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (!labelNames.contains(attr.name())) continue;
            labelAttributes.add(attr);
        }
        return labelAttributes;
    }

    public int[] getFeatureIndices() {
        int numAttributes = this.dataSet.numAttributes();
        Set<Attribute> featureAttributes = this.getFeatureAttributes();
        int[] featureIndices = new int[featureAttributes.size()];
        int counter = 0;
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (!featureAttributes.contains(attr)) continue;
            featureIndices[counter] = attr.index();
            ++counter;
        }
        return featureIndices;
    }

    public Set<Attribute> getFeatureAttributes() {
        Set<String> labelNames = this.labelsMetaData.getLabelNames();
        HashSet<Attribute> featureAttributes = new HashSet<Attribute>(this.getNumLabels());
        int numAttributes = this.dataSet.numAttributes();
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (labelNames.contains(attr.name())) continue;
            featureAttributes.add(attr);
        }
        return featureAttributes;
    }

    public LabelsMetaData getLabelsMetaData() {
        return this.labelsMetaData;
    }

    public Instances getDataSet() {
        return this.dataSet;
    }

    public MultiLabelInstances reintegrateModifiedDataSet(Instances modifiedDataSet) throws InvalidDataFormatException {
        if (modifiedDataSet == null) {
            throw new IllegalArgumentException("The modified data set is null.");
        }
        LabelsMetaDataImpl newMetaData = (LabelsMetaDataImpl)this.labelsMetaData.clone();
        Set<String> origLabelNames = this.labelsMetaData.getLabelNames();
        for (String labelName : origLabelNames) {
            if (modifiedDataSet.attribute(labelName) != null) continue;
            newMetaData.removeLabelNode(labelName);
        }
        return new MultiLabelInstances(modifiedDataSet, newMetaData);
    }

    public MultiLabelInstances clone() {
        LabelsMetaData metaDataCopy = this.labelsMetaData.clone();
        Instances dataSetCopy = new Instances(this.dataSet);
        try {
            return new MultiLabelInstances(dataSetCopy, metaDataCopy);
        }
        catch (InvalidDataFormatException ex) {
            throw new MulanRuntimeException(String.format("The cloning of '%' class instance failed", this.getClass()), ex);
        }
    }

    private Instances loadInstances(File arffFile) {
        if (!arffFile.exists()) {
            throw new IllegalArgumentException(String.format("The arff data file does not exists under specified path '%s'.", arffFile.getAbsolutePath()));
        }
        Instances aDataSet = null;
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(arffFile);
        }
        catch (FileNotFoundException exception) {
            throw new DataLoadException(String.format("The specified data file '%s' can not be found.", arffFile.getAbsolutePath()), exception);
        }
        aDataSet = this.loadInstances(fileStream);
        return aDataSet;
    }

    private Instances loadInstances(InputStream stream) {
        Instances aDataSet = null;
        InputStreamReader streamReader = new InputStreamReader(stream);
        try {
            aDataSet = new Instances((Reader)streamReader);
        }
        catch (IOException exception) {
            throw new DataLoadException(String.format("Error creating Instances data from supplied Reader data source: " + exception.getMessage(), exception));
        }
        return aDataSet;
    }

    private LabelsMetaData loadLabesMeta(String xmlLabelsDefFilePath) {
        LabelsMetaData labelsMeta = null;
        try {
            labelsMeta = LabelsBuilder.createLabels(xmlLabelsDefFilePath);
        }
        catch (LabelsBuilderException exception) {
            throw new DataLoadException(String.format("Error loading labels meta-data from xml file '%s'.", xmlLabelsDefFilePath), exception);
        }
        return labelsMeta;
    }

    private LabelsMetaData loadLabesMeta(InputStream xmlLabelsDefStream) {
        LabelsMetaData labelsMeta = null;
        try {
            labelsMeta = LabelsBuilder.createLabels(xmlLabelsDefStream);
        }
        catch (LabelsBuilderException exception) {
            throw new DataLoadException(String.format("Error loading labels meta-data from input stream.", new Object[0]), exception);
        }
        return labelsMeta;
    }

    private LabelsMetaData loadLabesMeta(Instances data, int numLabels) throws InvalidDataFormatException {
        LabelsMetaDataImpl labelsData = new LabelsMetaDataImpl();
        int numAttributes = data.numAttributes();
        for (int index = numAttributes - numLabels; index < numAttributes; ++index) {
            String attrName = data.attribute(index).name();
            labelsData.addRootNode(new LabelNodeImpl(attrName));
        }
        if (labelsData.getNumLabels() < numLabels) {
            throw new InvalidDataFormatException("The names of label attributes are not unique.");
        }
        return labelsData;
    }

    private void validate(Instances dataSet, LabelsMetaData labelsMetaData) throws InvalidDataFormatException {
        Set<String> labelNames = labelsMetaData.getLabelNames();
        if (labelNames.size() < 2) {
            throw new InvalidDataFormatException(String.format("There must be at least 2 label attributes specified, but only '%s' are defined in metadata", labelNames.size()));
        }
        int numAttributes = dataSet.numAttributes();
        int numMatches = 0;
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attribute = dataSet.attribute(index);
            if (!labelNames.contains(attribute.name())) continue;
            ++numMatches;
            if (this.checkLabelAttributeFormat(attribute)) continue;
            throw new InvalidDataFormatException(String.format("The format of label attribute '%s' is not valid.", attribute.name()));
        }
        if (numMatches != labelNames.size()) {
            throw new InvalidDataFormatException(String.format("Not all labels defined in meta-data are present in ARFF data file.", new Object[0]));
        }
        if (labelsMetaData.isHierarchy()) {
            this.checkLabelsConsistency(dataSet, labelsMetaData.getRootLabels());
        }
    }

    private boolean checkLabelAttributeFormat(Attribute attribute) {
        if (!attribute.isNominal()) {
            return false;
        }
        ArrayList<String> allowedValues = new ArrayList<String>();
        allowedValues.add("0");
        allowedValues.add("1");
        int numValues = attribute.numValues();
        if (allowedValues.size() != numValues) {
            return false;
        }
        for (int index = 0; index < numValues; ++index) {
            String value = attribute.value(index);
            if (!allowedValues.contains(value)) continue;
            allowedValues.remove(value);
        }
        return allowedValues.isEmpty();
    }

    private void checkLabelsConsistency(Instances dataSet, Set<LabelNode> rootLabelNodes) throws InvalidDataFormatException {
        HashMap<String, Attribute> attributesIndex = new HashMap<String, Attribute>();
        for (int index = 0; index < dataSet.numAttributes(); ++index) {
            Attribute attribute = dataSet.attribute(index);
            attributesIndex.put(attribute.name(), attribute);
        }
        int numInstances = dataSet.numInstances();
        for (int index = 0; index < numInstances; ++index) {
            Instance instance = dataSet.instance(index);
            for (LabelNode labelNode : rootLabelNodes) {
                this.checkSubtreeConsistency(labelNode, instance, true, attributesIndex);
            }
        }
    }

    private void checkSubtreeConsistency(LabelNode node, Instance instance, boolean canBeLabelSet, Map<String, Attribute> attributesIndex) throws InvalidDataFormatException {
        boolean isLabelSet = this.isLabelSet(instance, node.getName(), attributesIndex);
        if (isLabelSet && !canBeLabelSet) {
            throw new InvalidDataFormatException(String.format("Consistency of labels hierarchy is breached for: Label='%s', Instance='%s'", node.getName(), instance.toString()));
        }
        if (node.hasChildren()) {
            Set<LabelNode> childNodes = node.getChildren();
            for (LabelNode child : childNodes) {
                this.checkSubtreeConsistency(child, instance, isLabelSet, attributesIndex);
            }
        }
    }

    private boolean isLabelSet(Instance instance, String labelName, Map<String, Attribute> attributesIndex) {
        return instance.stringValue(attributesIndex.get(labelName)).equals("1");
    }

    public HashMap<String, Integer> getLabelDepth() {
        int numAttributes = this.dataSet.numAttributes();
        Set<String> labelNames = this.labelsMetaData.getLabelNames();
        HashMap<String, Integer> assoc = new HashMap<String, Integer>();
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (!labelNames.contains(attr.name())) continue;
            assoc.put(attr.name(), this.getDepth(attr.name()));
        }
        return assoc;
    }

    public int getDepth(String labelName) {
        int counter = 0;
        while (this.labelsMetaData.getLabelNode(labelName).hasParent()) {
            ++counter;
            labelName = this.labelsMetaData.getLabelNode(labelName).getParent().getName();
        }
        return counter + 1;
    }

    public int[] getLabelDepthIndices() {
        int[] labelDepthIndices = new int[this.labelsMetaData.getNumLabels()];
        int numAttributes = this.dataSet.numAttributes();
        Set<String> labelNames = this.labelsMetaData.getLabelNames();
        int counter = 0;
        for (int index = 0; index < numAttributes; ++index) {
            Attribute attr = this.dataSet.attribute(index);
            if (!labelNames.contains(attr.name())) continue;
            labelDepthIndices[counter] = this.getDepth(attr.name());
            ++counter;
        }
        return labelDepthIndices;
    }

    public boolean hasMissingLabels(Instance instance) {
        int numLabels = this.getNumLabels();
        int[] labelIndices = this.getLabelIndices();
        boolean missing = false;
        for (int j = 0; j < numLabels; ++j) {
            if (!instance.isMissing(labelIndices[j])) continue;
            missing = true;
            break;
        }
        return missing;
    }
}

