/*
 * Decompiled with CFR 0.152.
 */
package mulan.examples;

import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluation;
import mulan.evaluation.Evaluator;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.SerializationHelper;
import weka.core.Utils;

public class StoringAndLoadingModels {
    public static void main(String[] args) {
        try {
            String trainingDataFilename = Utils.getOption((String)"train", (String[])args);
            String testingDataFilename = Utils.getOption((String)"test", (String[])args);
            String labelsFilename = Utils.getOption((String)"labels", (String[])args);
            System.out.println("Loading the training data set...");
            MultiLabelInstances trainingData = new MultiLabelInstances(trainingDataFilename, labelsFilename);
            System.out.println("Loading the testing data set...");
            MultiLabelInstances testingData = new MultiLabelInstances(testingDataFilename, labelsFilename);
            BinaryRelevance learner1 = new BinaryRelevance((Classifier)new J48());
            String modelFilename = Utils.getOption((String)"model", (String[])args);
            System.out.println("Building the model...");
            learner1.build(trainingData);
            System.out.println("Storing the model...");
            SerializationHelper.write((String)modelFilename, (Object)learner1);
            System.out.println("Loading the model...");
            BinaryRelevance learner2 = (BinaryRelevance)SerializationHelper.read((String)modelFilename);
            Evaluator evaluator = new Evaluator();
            Evaluation evaluation = evaluator.evaluate(learner2, testingData);
            System.out.println(evaluation);
        }
        catch (Exception ex) {
            Logger.getLogger(StoringAndLoadingModels.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

