/*
 * Decompiled with CFR 0.152.
 */
package mulan.transformations;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.data.DataUtils;
import mulan.data.MultiLabelInstances;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.filters.unsupervised.attribute.Remove;

public class BinaryRelevanceTransformation
implements Serializable {
    private MultiLabelInstances data;
    private Instances shell;
    private Remove remove;
    private Add add;

    public BinaryRelevanceTransformation(MultiLabelInstances data) {
        try {
            this.data = data;
            this.remove = new Remove();
            int[] labelIndices = data.getLabelIndices();
            int[] indices = new int[labelIndices.length];
            System.arraycopy(labelIndices, 0, indices, 0, labelIndices.length);
            this.remove.setAttributeIndicesArray(indices);
            this.remove.setInvertSelection(false);
            this.remove.setInputFormat(data.getDataSet());
            this.shell = Filter.useFilter((Instances)data.getDataSet(), (Filter)this.remove);
            this.add = new Add();
            this.add.setAttributeIndex("last");
            this.add.setNominalLabels("0,1");
            this.add.setAttributeName("BinaryRelevanceLabel");
            this.add.setInputFormat(this.shell);
            this.shell = Filter.useFilter((Instances)this.shell, (Filter)this.add);
            this.shell.setClassIndex(this.shell.numAttributes() - 1);
        }
        catch (Exception ex) {
            Logger.getLogger(BinaryRelevanceTransformation.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Instance transformInstance(Instance instance, int labelToKeep) {
        this.remove.input(instance);
        Instance transformedInstance = this.remove.output();
        this.add.input(transformedInstance);
        transformedInstance = this.add.output();
        transformedInstance.setDataset(this.shell);
        int[] labelIndices = this.data.getLabelIndices();
        if (this.data.getDataSet().attribute(labelIndices[labelToKeep]).value(0).equals("1")) {
            transformedInstance.setValue(this.shell.numAttributes() - 1, 1.0 - instance.value(labelIndices[labelToKeep]));
        } else {
            transformedInstance.setValue(this.shell.numAttributes() - 1, instance.value(labelIndices[labelToKeep]));
        }
        return transformedInstance;
    }

    public Instances transformInstances(int labelToKeep) throws Exception {
        Instances shellCopy = new Instances(this.shell);
        boolean order10 = false;
        int[] labelIndices = this.data.getLabelIndices();
        if (this.data.getDataSet().attribute(labelIndices[labelToKeep]).value(0).equals("1")) {
            order10 = true;
        }
        for (int j = 0; j < shellCopy.numInstances(); ++j) {
            if (order10) {
                shellCopy.instance(j).setValue(shellCopy.numAttributes() - 1, 1.0 - this.data.getDataSet().instance(j).value(labelIndices[labelToKeep]));
                continue;
            }
            shellCopy.instance(j).setValue(shellCopy.numAttributes() - 1, this.data.getDataSet().instance(j).value(labelIndices[labelToKeep]));
        }
        return shellCopy;
    }

    public static Instances transformInstances(Instances train, int[] labelIndices, int indexToKeep) throws Exception {
        int numLabels = labelIndices.length;
        train.setClassIndex(indexToKeep);
        int[] indicesToRemove = new int[numLabels - 1];
        int counter2 = 0;
        for (int counter1 = 0; counter1 < numLabels; ++counter1) {
            if (labelIndices[counter1] == indexToKeep) continue;
            indicesToRemove[counter2] = labelIndices[counter1];
            ++counter2;
        }
        Remove remove = new Remove();
        remove.setAttributeIndicesArray(indicesToRemove);
        remove.setInputFormat(train);
        remove.setInvertSelection(true);
        Instances result = Filter.useFilter((Instances)train, (Filter)remove);
        return result;
    }

    public static Instance transformInstance(Instance instance, int[] labelIndices, int indexToKeep) {
        double[] values = instance.toDoubleArray();
        double[] transformedValues = new double[values.length - labelIndices.length + 1];
        int counterTransformed = 0;
        boolean isLabel = false;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < labelIndices.length; ++j) {
                if (i != labelIndices[j] || i == indexToKeep) continue;
                isLabel = true;
                break;
            }
            if (!isLabel) {
                transformedValues[counterTransformed] = instance.value(i);
                ++counterTransformed;
            }
            isLabel = false;
        }
        Instance transformedInstance = DataUtils.createInstance(instance, 1.0, transformedValues);
        return transformedInstance;
    }
}

