/*
 * Decompiled with CFR 0.152.
 */
package mulan.transformations.multiclass;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import mulan.transformations.multiclass.Copy;
import mulan.transformations.multiclass.MultiClassTransformationBase;
import mulan.transformations.multiclass.SelectionType;
import weka.core.Instance;
import weka.core.Instances;

public class SelectBasedOnFrequency
extends MultiClassTransformationBase {
    private SelectionType type;
    private int[] labelOccurance;

    public SelectBasedOnFrequency(SelectionType type) {
        this.type = type;
    }

    @Override
    public Instances transformInstances(MultiLabelInstances mlData) throws Exception {
        this.numOfLabels = mlData.getNumLabels();
        Instances data = mlData.getDataSet();
        this.labelOccurance = new int[this.numOfLabels];
        this.labelIndices = mlData.getLabelIndices();
        int numInstances = data.numInstances();
        for (int i = 0; i < numInstances; ++i) {
            for (int j = 0; j < this.numOfLabels; ++j) {
                if (!data.instance(i).attribute(this.labelIndices[j]).value((int)data.instance(i).value(this.labelIndices[j])).equals("1")) continue;
                int n = j;
                this.labelOccurance[n] = this.labelOccurance[n] + 1;
            }
        }
        return super.transformInstances(mlData);
    }

    @Override
    List<Instance> transformInstance(Instance instance) {
        int value = this.labelOccurance[0];
        int labelSelected = 0;
        for (int counter = 1; counter < this.numOfLabels; ++counter) {
            if (!instance.attribute(this.labelIndices[counter]).value((int)instance.value(this.labelIndices[counter])).equals("1")) continue;
            boolean test = false;
            switch (this.type) {
                case MIN: {
                    test = this.labelOccurance[counter] < value;
                    break;
                }
                case MAX: {
                    boolean bl = test = this.labelOccurance[counter] > value;
                }
            }
            if (!test) continue;
            value = this.labelOccurance[counter];
            labelSelected = counter;
        }
        Instance transformed = null;
        try {
            transformed = RemoveAllLabels.transformInstance(instance, this.labelIndices);
            transformed.setDataset(null);
            transformed.insertAttributeAt(transformed.numAttributes());
            transformed.setValue(transformed.numAttributes() - 1, (double)labelSelected);
        }
        catch (Exception ex) {
            Logger.getLogger(Copy.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<Instance> result = new ArrayList<Instance>();
        result.add(transformed);
        return result;
    }
}

