/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.analysis.RealFunction;
import JSci.maths.analysis.RealFunction2D;
import JSci.maths.analysis.RealFunctionND;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class RealFunction3D
implements Ring.Member {
    public abstract double map(double var1, double var3, double var5);

    public final int dimension() {
        return 3;
    }

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof RealFunction3D) {
            return this.add((RealFunction3D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction3D add(RealFunction3D realFunction3D) {
        return new Sum(this, realFunction3D);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof RealFunction3D) {
            return this.subtract((RealFunction3D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction3D subtract(RealFunction3D realFunction3D) {
        return new Difference(this, realFunction3D);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof RealFunction3D) {
            return this.multiply((RealFunction3D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction3D multiply(RealFunction3D realFunction3D) {
        return new Product(this, realFunction3D);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member member) {
        if (member instanceof RealFunction3D) {
            return this.divide((RealFunction3D)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction3D divide(RealFunction3D realFunction3D) {
        return new Quotient(this, realFunction3D);
    }

    public RealFunctionND tensor(RealFunction realFunction) {
        return new TensorProduct4D(this, realFunction);
    }

    public RealFunctionND tensor(RealFunction2D realFunction2D) {
        return new TensorProduct5D(this, realFunction2D);
    }

    public static RealFunction3D constant(double d) {
        return new Constant(d);
    }

    private static class Constant
    extends RealFunction3D {
        private final double A;

        public Constant(double d) {
            this.A = d;
        }

        public double map(double d, double d2, double d3) {
            return this.A;
        }
    }

    private static class TensorProduct5D
    extends RealFunctionND {
        private final RealFunction3D f1;
        private final RealFunction2D f2;

        public TensorProduct5D(RealFunction3D realFunction3D, RealFunction2D realFunction2D) {
            super(5);
            this.f1 = realFunction3D;
            this.f2 = realFunction2D;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray[0], dArray[1], dArray[2]) * this.f2.map(dArray[3], dArray[4]);
        }
    }

    private static class TensorProduct4D
    extends RealFunctionND {
        private final RealFunction3D f1;
        private final RealFunction f2;

        public TensorProduct4D(RealFunction3D realFunction3D, RealFunction realFunction) {
            super(4);
            this.f1 = realFunction3D;
            this.f2 = realFunction;
        }

        public double map(double[] dArray) {
            return this.f1.map(dArray[0], dArray[1], dArray[2]) * this.f2.map(dArray[3]);
        }
    }

    private static class Quotient
    extends RealFunction3D {
        private final RealFunction3D f1;
        private final RealFunction3D f2;

        public Quotient(RealFunction3D realFunction3D, RealFunction3D realFunction3D2) {
            this.f1 = realFunction3D;
            this.f2 = realFunction3D2;
        }

        public double map(double d, double d2, double d3) {
            return this.f1.map(d, d2, d3) / this.f2.map(d, d2, d3);
        }
    }

    private static class Reciprocal
    extends RealFunction3D {
        private final RealFunction3D f;

        public Reciprocal(RealFunction3D realFunction3D) {
            this.f = realFunction3D;
        }

        public double map(double d, double d2, double d3) {
            return 1.0 / this.f.map(d, d2, d3);
        }
    }

    private static class Product
    extends RealFunction3D {
        private final RealFunction3D f1;
        private final RealFunction3D f2;

        public Product(RealFunction3D realFunction3D, RealFunction3D realFunction3D2) {
            this.f1 = realFunction3D;
            this.f2 = realFunction3D2;
        }

        public double map(double d, double d2, double d3) {
            return this.f1.map(d, d2, d3) * this.f2.map(d, d2, d3);
        }
    }

    private static class Difference
    extends RealFunction3D {
        private final RealFunction3D f1;
        private final RealFunction3D f2;

        public Difference(RealFunction3D realFunction3D, RealFunction3D realFunction3D2) {
            this.f1 = realFunction3D;
            this.f2 = realFunction3D2;
        }

        public double map(double d, double d2, double d3) {
            return this.f1.map(d, d2, d3) - this.f2.map(d, d2, d3);
        }
    }

    private static class Sum
    extends RealFunction3D {
        private final RealFunction3D f1;
        private final RealFunction3D f2;

        public Sum(RealFunction3D realFunction3D, RealFunction3D realFunction3D2) {
            this.f1 = realFunction3D;
            this.f2 = realFunction3D2;
        }

        public double map(double d, double d2, double d3) {
            return this.f1.map(d, d2, d3) + this.f2.map(d, d2, d3);
        }
    }

    private static class Negation
    extends RealFunction3D {
        private final RealFunction3D f;

        public Negation(RealFunction3D realFunction3D) {
            this.f = realFunction3D;
        }

        public double map(double d, double d2, double d3) {
            return -this.f.map(d, d2, d3);
        }
    }
}

