/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies2;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.WaveletMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies2.Scaling2;
import JSci.maths.wavelet.daubechies2.Wavelet2;

public final class Daubechies2
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 2;
    protected static final int minlength = 4;
    static final double[] vgtemp = new double[]{0.482962913145, 0.836516303738, 0.224143868042, -0.129409522551};
    static final double[] v0temp = new double[]{0.848528137424, -0.529150262213};
    static final double[] v1temp = new double[]{0.132287565553, 0.212132034356, 0.838525491562, -0.484122918276};
    static final double[] vd0temp = new double[]{0.848528137424, 0.529150262213};
    static final double[] vd1temp = new double[]{-0.132287565553, 0.212132034356, 0.838525491562, 0.484122918276};
    static final double[] vg = ArrayMath.scalarMultiply(1.4142135623730951, vgtemp);
    static final double[] vd0 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd0temp));
    static final double[] vd1 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd1temp));
    static final double[] v0 = ArrayMath.scalarMultiply(1.4142135623730951, v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply(1.4142135623730951, v1temp);
    static final double[] phvg = WaveletMath.lowToHigh(vgtemp);
    static final double[] phv0 = new double[]{-0.512347538298, -0.821583836258, 0.216506350947, -0.125};
    static final double[] phvd0temp = new double[]{0.512347538298, -0.821583836258, 0.216506350946, 0.125};
    static final double[] phvd0 = ArrayMath.invert(phvd0temp);

    public int getFilterType() {
        return 2;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return new Scaling2(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new Scaling2(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return new Wavelet2(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new Wavelet2(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(2, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        int n2;
        if (dArray.length < 4) {
            throw new IllegalScalingException("The array is not long enough: " + dArray.length + " < " + 4);
        }
        double[] dArray2 = new double[2 * dArray.length - 2];
        int n3 = dArray.length - 1;
        for (n2 = 2; n2 <= n3 - 2; ++n2) {
            for (n = -2; n < 2; ++n) {
                int n4 = 2 * n2 + n;
                dArray2[n4] = dArray2[n4] + vg[n + 2] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add(dArray2, dArray[0], v0, 0);
        dArray2 = ArrayMath.add(dArray2, dArray[1], v1, 0);
        n2 = dArray2.length - vd0.length;
        n = dArray2.length - vd1.length;
        dArray2 = ArrayMath.add(dArray2, dArray[n3], vd0, n2);
        dArray2 = ArrayMath.add(dArray2, dArray[n3 - 1], vd1, n);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n;
        double[] dArray2 = new double[2 * dArray.length + 2];
        int n2 = dArray.length - 1;
        for (n = 1; n <= n2 - 1; ++n) {
            for (int i = -2; i < 2; ++i) {
                int n3 = 2 * n + i + 2;
                dArray2[n3] = dArray2[n3] + phvg[i + 2] * dArray[n];
            }
        }
        dArray2 = ArrayMath.add(dArray2, dArray[0], phv0, 0);
        n = dArray2.length - phvd0.length;
        dArray2 = ArrayMath.add(dArray2, dArray[n2], phvd0, n);
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, 2, n, n3, n2);
    }
}

