/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.transformer.AbstractArraySplitter;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ArrayFolds
extends AbstractArraySplitter {
    private static final long serialVersionUID = 8536100625511019961L;
    public static final String BACKUP_QUEUE = "queue";
    protected int m_Folds;
    protected List<TIntArrayList> m_Queue;

    public String globalInfo() {
        return "Generates a subset of the array, using folds similar to cross-validation.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList<TIntArrayList>();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    public void setFolds(int value) {
        if (value > 0) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().warning("Sample size must be >0, provided: " + value);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to generate.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)"folds: ");
        result = result + ", " + super.getQuickInfo();
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Queue != null) {
            result.put(BACKUP_QUEUE, this.m_Queue);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (List)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        int i;
        String result = null;
        Object arrayOld = this.m_InputToken.getPayload();
        TIntArrayList available = new TIntArrayList();
        for (i = 0; i < Array.getLength(arrayOld); ++i) {
            available.add(i);
        }
        TIntArrayList indices = new TIntArrayList();
        this.m_Generator.setMinValue(0);
        while (available.size() > 0) {
            if (available.size() == 1) {
                i = 0;
            } else {
                this.m_Generator.setMaxValue(available.size() - 1);
                i = this.m_Generator.next().intValue();
            }
            indices.add(available.get(i));
            available.removeAt(i);
        }
        this.m_Queue.clear();
        for (int n = 0; n < this.m_Folds; ++n) {
            int from = (int)Math.round((double)n * ((double)indices.size() / (double)this.m_Folds));
            int to = (int)Math.round((double)(n + 1) * ((double)indices.size() / (double)this.m_Folds));
            available = new TIntArrayList();
            for (i = from; i < to; ++i) {
                available.add(indices.get(i));
            }
            available.sort();
            this.m_Queue.add(available);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public Token output() {
        TIntArrayList indices = this.m_Queue.remove(0);
        Object arrayOld = this.m_InputToken.getPayload();
        TIntArrayList available = new TIntArrayList();
        for (int i = 0; i < Array.getLength(arrayOld); ++i) {
            if (indices.contains(i)) continue;
            available.add(i);
        }
        String suffix = " " + (this.m_Folds - this.m_Queue.size()) + "/" + this.m_Folds;
        switch (this.m_SplitResult) {
            case SPLIT: {
                Object arrayNew = this.newArray(arrayOld, indices, "split" + suffix);
                this.m_OutputToken = new Token(arrayNew);
                break;
            }
            case INVERSE: {
                Object arrayNew = this.newArray(arrayOld, available, "inverse" + suffix);
                this.m_OutputToken = new Token(arrayNew);
                break;
            }
            case BOTH: {
                Object arrayNew = Array.newInstance(arrayOld.getClass(), 2);
                Array.set(arrayNew, 0, this.newArray(arrayOld, indices, "split" + suffix));
                Array.set(arrayNew, 1, this.newArray(arrayOld, available, "inverse" + suffix));
                this.m_OutputToken = new Token(arrayNew);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled split result: " + this.m_SplitResult);
            }
        }
        this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        return this.m_OutputToken;
    }
}

