/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.wavelet.ShrinkThresholdSoft_F32;
import boofcv.alg.denoise.wavelet.SubbandShrink;
import boofcv.alg.denoise.wavelet.UtilDenoiseWavelet;
import boofcv.struct.image.ImageFloat32;
import java.util.Arrays;

public class DenoiseSureShrink_F32
extends SubbandShrink<ImageFloat32> {
    float noiseSigma;

    public DenoiseSureShrink_F32() {
        super(new ShrinkThresholdSoft_F32());
    }

    @Override
    protected Number computeThreshold(ImageFloat32 subband) {
        float c;
        float[] coef = new float[subband.width * subband.height];
        UtilDenoiseWavelet.subbandAbsVal(subband, coef);
        Arrays.sort(coef);
        float maxThreshold = (float)UtilDenoiseWavelet.universalThreshold(subband, 1.0);
        float N = coef.length;
        float threshold = maxThreshold;
        float bestRisk = Float.MAX_VALUE;
        float sumW = 0.0f;
        float right = N - 2.0f;
        int i = 0;
        while (i < coef.length && !((c = coef[i] / this.noiseSigma) > maxThreshold)) {
            float cc = c * c;
            float risk = (sumW += cc) + cc * (N - (float)i - 1.0f) + right;
            if (risk < bestRisk) {
                threshold = c;
                bestRisk = risk;
            }
            ++i;
            right -= 2.0f;
        }
        return Float.valueOf(this.noiseSigma * threshold);
    }

    @Override
    public void denoise(ImageFloat32 transform, int numLevels) {
        int w = transform.width;
        int h = transform.height;
        this.noiseSigma = UtilDenoiseWavelet.estimateNoiseStdDev(transform.subimage(w / 2, h / 2, w, h, null), null);
        this.performShrinkage(transform, numLevels);
    }
}

