/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel1D;

public class Kernel1D_F64
extends Kernel1D {
    public double[] data;

    public Kernel1D_F64(double[] data, int width) {
        this(data, width / 2, width);
        if (width % 2 != 1) {
            throw new IllegalArgumentException("Kernel must be add to use this constructor");
        }
    }

    public Kernel1D_F64(double[] data, int offset, int width) {
        super(offset, width);
        this.data = new double[width];
        System.arraycopy(data, 0, this.data, 0, width);
    }

    public Kernel1D_F64(int width) {
        this(width / 2, width);
    }

    public Kernel1D_F64(int offset, int width) {
        super(offset, width);
        this.data = new double[width];
    }

    protected Kernel1D_F64() {
    }

    @Override
    public double getDouble(int index) {
        return this.data[index];
    }

    public static Kernel1D_F64 wrap(double[] data, int width) {
        Kernel1D_F64 ret = new Kernel1D_F64();
        ret.data = data;
        ret.width = width;
        ret.offset = width / 2;
        return ret;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public double get(int i) {
        return this.data[i];
    }

    public double computeSum() {
        double sum = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            sum += this.data[i];
        }
        return sum;
    }

    public double[] getData() {
        return this.data;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
        }
        System.out.println();
    }
}

