/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.feature.associate.HammingTable16;
import boofcv.alg.feature.shapes.SplitMergeLineFitLoop;
import boofcv.alg.fiducial.BaseDetectFiducialSquare;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.util.ArrayList;
import java.util.List;

public class DetectFiducialSquareImage<T extends ImageSingleBand>
extends BaseDetectFiducialSquare<T> {
    private static final int w = 16;
    private static final int squareLength = 64;
    private static final int DESC_LENGTH = 256;
    private InputToBinary<ImageFloat32> threshold = FactoryThresholdBinary.globalOtsu((int)0, (int)256, (boolean)true, ImageFloat32.class);
    private ImageUInt8 binary = new ImageUInt8(64, 64);
    private List<FiducialDef> targets = new ArrayList<FiducialDef>();
    private HammingTable16 table = new HammingTable16();
    private short[] squareDef = new short[256];
    private ImageFloat32 grayNoBorder = new ImageFloat32();
    private int hammingThreshold;

    public DetectFiducialSquareImage(InputToBinary<T> thresholder, SplitMergeLineFitLoop fitPolygon, double minContourFraction, double matchThreshold, Class<T> inputType) {
        super(thresholder, fitPolygon, 128, minContourFraction, inputType);
        this.hammingThreshold = (int)(4096.0 * matchThreshold);
    }

    public int addImage(T grayScale, double threshold) {
        ImageSingleBand scaled = GeneralizedImageOps.createSingleBand(this.getInputType(), (int)64, (int)64);
        DistortImageOps.scale(grayScale, (ImageBase)scaled, (TypeInterpolate)TypeInterpolate.BILINEAR);
        ImageUInt8 binary0 = this.binary;
        ImageUInt8 binary1 = new ImageUInt8(64, 64);
        GThresholdImageOps.threshold((ImageSingleBand)scaled, (ImageUInt8)binary0, (double)threshold, (boolean)true);
        FiducialDef def = new FiducialDef();
        DetectFiducialSquareImage.binaryToDef(binary0, def.desc[0]);
        ImageMiscOps.rotateCW((ImageInt8)binary0, (ImageInt8)binary1);
        DetectFiducialSquareImage.binaryToDef(binary1, def.desc[1]);
        ImageMiscOps.rotateCW((ImageInt8)binary1, (ImageInt8)binary0);
        DetectFiducialSquareImage.binaryToDef(binary0, def.desc[2]);
        ImageMiscOps.rotateCW((ImageInt8)binary0, (ImageInt8)binary1);
        DetectFiducialSquareImage.binaryToDef(binary1, def.desc[3]);
        int index = this.targets.size();
        this.targets.add(def);
        return index;
    }

    protected static void binaryToDef(ImageUInt8 binary, short[] desc) {
        for (int i = 0; i < binary.data.length; i += 16) {
            int value = 0;
            for (int j = 0; j < 16; ++j) {
                value |= binary.data[i + j] << j;
            }
            desc[i / 16] = (short)value;
        }
    }

    @Override
    protected boolean processSquare(ImageFloat32 gray, BaseDetectFiducialSquare.Result result) {
        int off = (gray.width - this.binary.width) / 2;
        gray.subimage(off, off, gray.width - off, gray.width - off, (ImageSingleBand)this.grayNoBorder);
        this.threshold.process((ImageBase)this.grayNoBorder, (ImageBase)this.binary);
        DetectFiducialSquareImage.binaryToDef(this.binary, this.squareDef);
        for (int i = 0; i < this.targets.size(); ++i) {
            FiducialDef def = this.targets.get(i);
            int bestOrientation = 0;
            int bestScore = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                int score = this.hamming(def.desc[j], this.squareDef);
                if (score >= bestScore) continue;
                bestScore = score;
                bestOrientation = j;
            }
            if (bestScore > this.hammingThreshold) continue;
            result.rotation = bestOrientation;
            result.which = i;
            return true;
        }
        return false;
    }

    protected int hamming(short[] a, short[] b) {
        int distance = 0;
        for (int i = 0; i < a.length; ++i) {
            distance += this.table.lookup(a[i], b[i]);
        }
        return distance;
    }

    public List<FiducialDef> getTargets() {
        return this.targets;
    }

    protected static class FiducialDef {
        short[][] desc = new short[4][256];

        protected FiducialDef() {
        }
    }
}

