/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class FuzzyOpponentHistogram
extends Histogram
implements LireFeature {
    final double sq2 = Math.sqrt(2.0);
    final double sq6 = Math.sqrt(3.0);
    final double sq3 = Math.sqrt(6.0);
    double o1;
    double o2;
    double o3;
    double[] o1f = new double[4];
    double[] o2f = new double[4];
    double[] o3f = new double[4];
    private int[] tmpIntensity = new int[1];

    @Override
    public void extract(BufferedImage bimg) {
        int j;
        int i;
        double[][] histogram = new double[64][9];
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            for (int j2 = 0; j2 < histogram[i2].length; ++j2) {
                histogram[i2][j2] = 0.0;
            }
        }
        WritableRaster grey = ImageUtils.getGrayscaleImage(bimg).getRaster();
        WritableRaster raster = bimg.getRaster();
        int[] px = new int[3];
        int[] intens = new int[1];
        for (int x = 1; x < raster.getWidth() - 1; ++x) {
            for (int y = 1; y < raster.getHeight() - 1; ++y) {
                raster.getPixel(x, y, px);
                this.o1 = (double)(px[0] - px[1]) / this.sq2;
                this.o2 = (double)(px[0] + px[1] - 2 * px[2]) / this.sq6;
                this.o3 = (double)(px[0] + px[1] + px[2]) / this.sq3;
                this.o1 = (this.o1 + 255.0 / this.sq2) / (510.0 / this.sq2);
                this.o2 = (this.o2 + 510.0 / this.sq6) / (1020.0 / this.sq6);
                this.o3 /= 765.0 / this.sq3;
                this.getFuzzyMembership(this.o1, this.o1f);
                this.getFuzzyMembership(this.o2, this.o2f);
                this.getFuzzyMembership(this.o3, this.o3f);
                int rank = 0;
                grey.getPixel(x, y, intens);
                if (this.getIntensity(x - 1, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x - 1, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x - 1, y, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y, grey) > intens[0]) {
                    ++rank;
                }
                for (int i3 = 0; i3 < this.o1f.length; ++i3) {
                    if (this.o1f[i3] == 0.0) continue;
                    for (int j3 = 0; j3 < this.o2f.length; ++j3) {
                        if (this.o2f[j3] == 0.0) continue;
                        for (int k = 0; k < this.o3f.length; ++k) {
                            if (this.o3f[k] == 0.0) continue;
                            int colorPos = i3 + j3 * 3 + k * 3 * 3;
                            double[] dArray = histogram[colorPos];
                            int n = rank;
                            dArray[n] = dArray[n] + this.o1f[i3] * this.o2f[j3] * this.o3f[k];
                        }
                    }
                }
            }
        }
        this.descriptor = new double[576];
        double max = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            for (j = 0; j < histogram[i].length; ++j) {
                max = Math.max(histogram[i][j], max);
            }
        }
        for (i = 0; i < histogram.length; ++i) {
            for (j = 0; j < histogram[i].length; ++j) {
                this.descriptor[i + 27 * j] = Math.floor(127.0 * (histogram[i][j] / max));
            }
        }
    }

    private void getFuzzyMembership(double in, double[] out) {
        out[0] = 0.0;
        out[1] = 0.0;
        out[2] = 0.0;
        out[3] = 0.0;
        if (in <= 0.15) {
            out[0] = 1.0;
        } else if (in > 0.15 && in < 0.25) {
            out[0] = (in - 0.15) * 10.0;
            out[1] = 1.0 - out[0];
        } else if (in >= 0.25 && in <= 0.45) {
            out[1] = 1.0;
        } else if (in > 0.45 && in < 0.55) {
            out[1] = (in - 0.45) * 10.0;
            out[2] = 1.0 - out[1];
        } else if (in >= 0.55 && in <= 0.75) {
            out[2] = 1.0;
        } else if (in > 0.75 && in < 0.85) {
            out[2] = (in - 0.75) * 10.0;
            out[3] = 1.0 - out[2];
        } else if (in >= 0.85) {
            out[3] = 1.0;
        }
    }

    private int getIntensity(int x, int y, WritableRaster grey) {
        grey.getPixel(x, y, this.tmpIntensity);
        return this.tmpIntensity[0];
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.descriptor.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)this.descriptor[i];
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.descriptor = new double[in.length];
        for (int i = 0; i < this.descriptor.length; ++i) {
            this.descriptor[i] = in[i];
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.descriptor = new double[length];
        for (int i = offset; i < length; ++i) {
            this.descriptor[i] = in[i];
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.descriptor;
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof FuzzyOpponentHistogram)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        return MetricsUtils.jsd(((FuzzyOpponentHistogram)feature).descriptor, this.descriptor);
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.descriptor.length * 2 + 25);
        sb.append("ophist");
        sb.append(' ');
        sb.append(this.descriptor.length);
        sb.append(' ');
        for (double aData : this.descriptor) {
            sb.append((int)aData);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.nextToken().equals("ophist")) {
            throw new UnsupportedOperationException("This is not a OpponentHistogram descriptor.");
        }
        this.descriptor = new double[Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.descriptor.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.descriptor[i] = Integer.parseInt(st.nextToken());
        }
    }

    @Override
    public String getFeatureName() {
        return "Fuzzy Opponent Histogram";
    }

    @Override
    public String getFieldName() {
        return "f_fuzopphis";
    }
}

