/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.correlogram;

import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.correlogram.IAutoCorrelogramFeatureExtractor;

public class DynamicProgrammingAutoCorrelogramExtraction
implements IAutoCorrelogramFeatureExtractor {
    public static final DynamicProgrammingAutoCorrelogramExtraction instance = new DynamicProgrammingAutoCorrelogramExtraction();
    private int[][][] Ic = null;
    private int[][][][] ah = null;
    private int[][][][] av = null;
    private int[] NIc = null;
    private int MAXC = 64;
    private int MAXH = 200;
    private int MAXW = 200;
    private int MAXD = 5;

    public static final DynamicProgrammingAutoCorrelogramExtraction getInstance() {
        return instance;
    }

    private DynamicProgrammingAutoCorrelogramExtraction() {
    }

    @Override
    public synchronized float[][] extract(int maxFeatureValue, int[] distanceSet, int[][] img) {
        int c;
        int c2;
        int y;
        int x;
        long totalComplexity = 0L;
        int W = img.length;
        int H = img[0].length;
        int MAX_D = distanceSet[distanceSet.length - 1];
        float[][] A = new float[maxFeatureValue][distanceSet.length];
        float[] Hi = new float[maxFeatureValue];
        if (this.Ic == null || this.ah == null || this.av == null || this.NIc == null || maxFeatureValue > this.MAXC || W > this.MAXW || H > this.MAXH || MAX_D > this.MAXD) {
            this.Ic = null;
            this.NIc = null;
            this.ah = null;
            this.av = null;
            System.gc();
            this.MAXC = Math.max(this.MAXC, maxFeatureValue);
            this.MAXW = Math.max(this.MAXW, W);
            this.MAXD = Math.max(this.MAXD, MAX_D);
            this.MAXH = Math.max(this.MAXH, H);
            this.Ic = new int[this.MAXC][this.MAXH * this.MAXW][2];
            this.NIc = new int[this.MAXC];
            this.ah = new int[this.MAXD][this.MAXW][this.MAXH][this.MAXC];
            this.av = new int[this.MAXD - 1][this.MAXW][this.MAXH][this.MAXC];
        }
        for (int x2 = 0; x2 < W; ++x2) {
            for (int y2 = 0; y2 < H; ++y2) {
                int n = img[x2][y2];
                Hi[n] = Hi[n] + 1.0f;
                ++totalComplexity;
            }
        }
        Arrays.fill(this.NIc, 0);
        int[][][] ah0 = new int[W][H][maxFeatureValue];
        int[][][] av0 = new int[W][H][maxFeatureValue];
        for (x = 0; x < W; ++x) {
            for (y = 0; y < H; ++y) {
                this.Ic[img[x][y]][this.NIc[img[x][y]]][0] = x;
                this.Ic[img[x][y]][this.NIc[img[x][y]]][1] = y;
                int n = img[x][y];
                this.NIc[n] = this.NIc[n] + 1;
                av0[x][y][img[x][y]] = 1;
                ah0[x][y][img[x][y]] = 1;
                ++totalComplexity;
            }
        }
        for (x = 0; x < W; ++x) {
            for (y = 0; y < H; ++y) {
                int d;
                c2 = img[x][y];
                this.ah[0][x][y][c2] = ah0[x][y][c2] + (x + 1 < W ? ah0[x + 1][y][c2] : 0);
                this.av[0][x][y][c2] = av0[x][y][c2] + (y + 1 < H ? ah0[x][y + 1][c2] : 0);
                for (d = 2; d <= MAX_D; ++d) {
                    this.ah[d - 1][x][y][c2] = this.ah[d - 2][x][y][c2] + (x + d < W ? ah0[x + d][y][c2] : 0);
                    ++totalComplexity;
                }
                for (d = 2; d <= MAX_D - 1; ++d) {
                    this.av[d - 1][x][y][c2] = this.av[d - 2][x][y][c2] + (y + d < H ? av0[x][y + d][c2] : 0);
                }
            }
        }
        for (c = 0; c < maxFeatureValue; ++c) {
            for (int i = 0; i < this.NIc[c]; ++i) {
                int x3 = this.Ic[c][i][0];
                int y3 = this.Ic[c][i][1];
                float[] fArray = A[c];
                fArray[0] = fArray[0] + (float)((y3 - 1 >= 0 ? (x3 - 1 >= 0 ? this.ah[0][x3 - 1][y3 - 1][c] : 0) + this.ah[0][x3][y3 - 1][c] : 0) + (y3 + 1 < H ? (x3 - 1 >= 0 ? this.ah[0][x3 - 1][y3 + 1][c] : 0) + this.ah[0][x3][y3 + 1][c] : 0) + (x3 - 1 >= 0 ? av0[x3 - 1][y3][c] + av0[x3 - 1][y3][c] : 0) + (x3 + 1 < W ? av0[x3 + 1][y3][c] + av0[x3 + 1][y3][c] : 0));
                ++totalComplexity;
            }
        }
        for (int di = 1; di < distanceSet.length; ++di) {
            int d = distanceSet[di];
            for (c2 = 0; c2 < maxFeatureValue; ++c2) {
                for (int i = 0; i < this.NIc[c2]; ++i) {
                    int x4 = this.Ic[c2][i][0];
                    int y4 = this.Ic[c2][i][1];
                    float[] fArray = A[c2];
                    int n = di;
                    fArray[n] = fArray[n] + (float)((y4 - d >= 0 ? (x4 - d >= 0 ? this.ah[d - 1][x4 - d][y4 - d][c2] : 0) + this.ah[d - 1][x4][y4 - d][c2] : 0) + (y4 + d < H ? (x4 - d >= 0 ? this.ah[d - 1][x4 - d][y4 + d][c2] : 0) + this.ah[d - 1][x4][y4 + d][c2] : 0) + (x4 - d >= 0 ? (y4 - d + 1 >= 0 ? this.av[d - 2][x4 - d][y4 - d + 1][c2] : 0) + this.av[d - 2][x4 - d][y4][c2] : 0) + (x4 + d < W ? (y4 - d + 1 >= 0 ? this.av[d - 2][x4 + d][y4 - d + 1][c2] : 0) + this.av[d - 2][x4 + d][y4][c2] : 0));
                    ++totalComplexity;
                }
            }
        }
        for (c = 0; c < maxFeatureValue; ++c) {
            for (int di = 0; di < distanceSet.length; ++di) {
                int d = distanceSet[di];
                if (!(Hi[c] > 0.0f)) continue;
                float[] fArray = A[c];
                int n = di;
                fArray[n] = fArray[n] / (Hi[c] * (float)d * 8.0f);
            }
        }
        return A;
    }

    public static void main(String[] args) {
        int[][] I = new int[384][256];
        float[][] A = null;
        int C = 64;
        int[] D = new int[]{1, 3, 5, 7};
        for (int i = 0; i < I.length; ++i) {
            for (int j = 0; j < I[i].length; ++j) {
                I[i][j] = (i + 1) * (j * j + 1) % C;
            }
        }
        long tf = System.currentTimeMillis();
        DynamicProgrammingAutoCorrelogramExtraction dynACorrExt = new DynamicProgrammingAutoCorrelogramExtraction();
        for (int i = 0; i < 10; ++i) {
            long t0 = tf;
            A = dynACorrExt.extract(C, D, I);
            tf = System.currentTimeMillis();
            System.out.println("Exctraction " + (i + 1) + " time: " + (tf - t0) + "ms");
        }
        System.out.println("Please, ignore the first exctraction (buffers initialization)!");
        DynamicProgrammingAutoCorrelogramExtraction.print(A);
    }

    static void print(float[][] M) {
        System.out.println();
        for (int i = 0; i < M.length; ++i) {
            for (int j = 0; j < M[i].length; ++j) {
                System.out.print(M[i][j] + " ");
            }
            System.out.println();
        }
    }

    static void print(int[][] M) {
        System.out.println();
        for (int i = 0; i < M.length; ++i) {
            for (int j = 0; j < M[i].length; ++j) {
                System.out.print(M[i][j] + " ");
            }
            System.out.println();
        }
    }
}

