/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.correlogram;

import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram;
import net.semanticmetadata.lire.imageanalysis.correlogram.IAutoCorrelogramFeatureExtractor;

public class MLuxAutoCorrelogramExtraction
implements IAutoCorrelogramFeatureExtractor {
    private AutoColorCorrelogram.Mode mode;

    public MLuxAutoCorrelogramExtraction() {
        this(AutoColorCorrelogram.Mode.SuperFast);
    }

    public MLuxAutoCorrelogramExtraction(AutoColorCorrelogram.Mode mode) {
        this.mode = mode;
    }

    @Override
    public float[][] extract(int maxFeatureValue, int[] distanceSet, int[][] img) {
        int i;
        int c;
        int[] histogram = new int[maxFeatureValue];
        int W = img.length;
        int H = img[0].length;
        for (int x = 0; x < W; ++x) {
            for (int y = 0; y < H; ++y) {
                int n = img[x][y];
                histogram[n] = histogram[n] + 1;
            }
        }
        float[][] correlogram = new float[maxFeatureValue][distanceSet.length];
        int[] tmpCorrelogram = new int[distanceSet.length];
        for (int x = 0; x < W; ++x) {
            for (int y = 0; y < H; ++y) {
                int color = img[x][y];
                this.getNumPixelsInNeighbourhood(x, y, img, tmpCorrelogram, maxFeatureValue, distanceSet);
                for (int i2 = 0; i2 < distanceSet.length; ++i2) {
                    float[] fArray = correlogram[color];
                    int n = i2;
                    fArray[n] = fArray[n] + (float)tmpCorrelogram[i2];
                }
            }
        }
        float[] max = new float[distanceSet.length];
        for (c = 0; c < maxFeatureValue; ++c) {
            for (i = 0; i < distanceSet.length; ++i) {
                max[i] = Math.max(correlogram[c][i], max[i]);
            }
        }
        for (c = 0; c < maxFeatureValue; ++c) {
            for (i = 0; i < distanceSet.length; ++i) {
                correlogram[c][i] = correlogram[c][i] / max[i];
            }
        }
        return correlogram;
    }

    private void getNumPixelsInNeighbourhood(int x, int y, int[][] quantPixels, int[] correlogramm, int maxFeatureValue, int[] distanceSet) {
        Arrays.fill(correlogramm, 0);
        for (int di = 0; di < distanceSet.length; ++di) {
            int d = distanceSet[di];
            if (di > 0) {
                int n = di;
                correlogramm[n] = correlogramm[n] + correlogramm[di - 1];
            }
            int color = quantPixels[x][y];
            if (this.mode == AutoColorCorrelogram.Mode.QuarterNeighbourhood) {
                for (int td = 0; td < d; ++td) {
                    if (MLuxAutoCorrelogramExtraction.isInPicture(x + d, y + td, quantPixels.length, quantPixels[0].length) && quantPixels[x + d][y + td] == color) {
                        int n = di;
                        correlogramm[n] = correlogramm[n] + 1;
                    }
                    if (MLuxAutoCorrelogramExtraction.isInPicture(x + td, y + d, quantPixels.length, quantPixels[0].length) && color == quantPixels[x + td][y + d]) {
                        int n = di;
                        correlogramm[n] = correlogramm[n] + 1;
                    }
                    if (!MLuxAutoCorrelogramExtraction.isInPicture(x + d, y + d, quantPixels.length, quantPixels[0].length) || color != quantPixels[x + d][y + d]) continue;
                    int n = di;
                    correlogramm[n] = correlogramm[n] + 1;
                }
                continue;
            }
            if (this.mode == AutoColorCorrelogram.Mode.FullNeighbourhood) {
                int i;
                for (i = -d; i <= d; ++i) {
                    if (MLuxAutoCorrelogramExtraction.isInPicture(x + i, y + d, quantPixels.length, quantPixels[0].length) && color == quantPixels[x + i][y + d]) {
                        int n = di;
                        correlogramm[n] = correlogramm[n] + 1;
                    }
                    if (!MLuxAutoCorrelogramExtraction.isInPicture(x + i, y - d, quantPixels.length, quantPixels[0].length) || color != quantPixels[x + i][y - d]) continue;
                    int n = di;
                    correlogramm[n] = correlogramm[n] + 1;
                }
                for (i = -d + 1; i <= d - 1; ++i) {
                    if (MLuxAutoCorrelogramExtraction.isInPicture(x + d, y + i, quantPixels.length, quantPixels[0].length) && color == quantPixels[x + d][y + i]) {
                        int n = di;
                        correlogramm[n] = correlogramm[n] + 1;
                    }
                    if (!MLuxAutoCorrelogramExtraction.isInPicture(x - d, y + i, quantPixels.length, quantPixels[0].length) || color != quantPixels[x - d][y + i]) continue;
                    int n = di;
                    correlogramm[n] = correlogramm[n] + 1;
                }
                continue;
            }
            if (MLuxAutoCorrelogramExtraction.isInPicture(x + d, y, quantPixels.length, quantPixels[0].length)) {
                assert (quantPixels[x + d][y] < maxFeatureValue);
                if (color == quantPixels[x + d][y]) {
                    int n = di;
                    correlogramm[n] = correlogramm[n] + 1;
                }
            }
            if (!MLuxAutoCorrelogramExtraction.isInPicture(x, y + d, quantPixels.length, quantPixels[0].length)) continue;
            assert (quantPixels[x][y + d] < maxFeatureValue);
            if (color != quantPixels[x][y + d]) continue;
            int n = di;
            correlogramm[n] = correlogramm[n] + 1;
        }
    }

    private static boolean isInPicture(int x, int y, int maxX, int maxY) {
        return x >= 0 && y >= 0 && y < maxY && x < maxX;
    }
}

