/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.joint;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class JointHistogram
extends Histogram
implements LireFeature {
    private int[] tmpIntensity = new int[1];

    @Override
    public void extract(BufferedImage bimg) {
        int j;
        int i;
        bimg = ImageUtils.get8BitRGBImage(bimg);
        int[][] histogram = new int[64][9];
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            for (int j2 = 0; j2 < histogram[i2].length; ++j2) {
                histogram[i2][j2] = 0;
            }
        }
        WritableRaster grey = ImageUtils.getGrayscaleImage(bimg).getRaster();
        WritableRaster raster = bimg.getRaster();
        int[] px = new int[3];
        int[] intens = new int[1];
        for (int x = 1; x < raster.getWidth() - 1; ++x) {
            for (int y = 1; y < raster.getHeight() - 1; ++y) {
                raster.getPixel(x, y, px);
                int colorPos = (int)Math.round((double)px[2] / 85.0) + (int)Math.round((double)px[1] / 85.0) * 4 + (int)Math.round((double)px[0] / 85.0) * 4 * 4;
                int rank = 0;
                grey.getPixel(x, y, intens);
                if (this.getIntensity(x - 1, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y - 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x - 1, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y + 1, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x - 1, y, grey) > intens[0]) {
                    ++rank;
                }
                if (this.getIntensity(x + 1, y, grey) > intens[0]) {
                    // empty if block
                }
                int[] nArray = histogram[colorPos];
                int n = ++rank;
                nArray[n] = nArray[n] + 1;
            }
        }
        this.descriptor = new double[576];
        double max = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            for (j = 0; j < histogram[i].length; ++j) {
                max = Math.max((double)histogram[i][j], max);
            }
        }
        for (i = 0; i < histogram.length; ++i) {
            for (j = 0; j < histogram[i].length; ++j) {
                this.descriptor[i + 64 * j] = Math.floor(127.0 * ((double)histogram[i][j] / max));
            }
        }
    }

    private int getIntensity(int x, int y, WritableRaster grey) {
        grey.getPixel(x, y, this.tmpIntensity);
        return this.tmpIntensity[0];
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.descriptor.length * 2 + 25);
        sb.append("jhist");
        sb.append(' ');
        sb.append(this.descriptor.length);
        sb.append(' ');
        for (double aData : this.descriptor) {
            sb.append((int)aData);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.nextToken().equals("jhist")) {
            throw new UnsupportedOperationException("This is not a JointHistogram descriptor.");
        }
        this.descriptor = new double[Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.descriptor.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.descriptor[i] = Integer.parseInt(st.nextToken());
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.descriptor.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)this.descriptor[i];
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.descriptor = new double[in.length];
        for (int i = 0; i < this.descriptor.length; ++i) {
            this.descriptor[i] = in[i];
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.descriptor = new double[length];
        for (int i = offset; i < length; ++i) {
            this.descriptor[i] = in[i];
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        double[] result = new double[this.descriptor.length];
        for (int i = 0; i < this.descriptor.length; ++i) {
            result[i] = this.descriptor[i];
        }
        return result;
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof JointHistogram)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        return MetricsUtils.jsd(((JointHistogram)feature).descriptor, this.descriptor);
    }

    @Override
    public String getFeatureName() {
        return "Joint Histogram Rank RBG";
    }

    @Override
    public String getFieldName() {
        return "featureJointHist";
    }
}

