/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.spatialpyramid;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.FCTH;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class SPFCTH
implements LireFeature {
    private int histLength = 192;
    int histogramSize = this.histLength * 5 + this.histLength * 4 * 4;
    double[] histogram = new double[this.histogramSize];
    int tmp;

    @Override
    public void extract(BufferedImage bimg) {
        FCTH fcth = new FCTH();
        fcth.extract(bimg);
        System.arraycopy(fcth.getDoubleHistogram(), 0, this.histogram, 0, this.histLength);
        int w = bimg.getWidth() / 2;
        int h = bimg.getHeight() / 2;
        fcth.extract(bimg.getSubimage(0, 0, w, h));
        System.arraycopy(fcth.getDoubleHistogram(), 0, this.histogram, this.histLength * 1, this.histLength);
        fcth.extract(bimg.getSubimage(w, 0, w, h));
        System.arraycopy(fcth.getDoubleHistogram(), 0, this.histogram, this.histLength * 2, this.histLength);
        fcth.extract(bimg.getSubimage(0, h, w, h));
        System.arraycopy(fcth.getDoubleHistogram(), 0, this.histogram, this.histLength * 3, this.histLength);
        fcth.extract(bimg.getSubimage(w, h, w, h));
        System.arraycopy(fcth.getDoubleHistogram(), 0, this.histogram, this.histLength * 4, this.histLength);
        int wstep = bimg.getWidth() / 4;
        int hstep = bimg.getHeight() / 4;
        int binPos = 5;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                fcth.extract(bimg.getSubimage(i * wstep, j * hstep, wstep, hstep));
                System.arraycopy(fcth.getDoubleHistogram(), 0, this.histogram, this.histLength * binPos, this.histLength);
                ++binPos;
            }
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int position = -1;
        for (int i = 0; i < this.histogram.length; ++i) {
            if (position == -1) {
                if (this.histogram[i] != 0.0) continue;
                position = i;
                continue;
            }
            if (position <= -1 || this.histogram[i] == 0.0) continue;
            position = -1;
        }
        if (position < 0) {
            position = 143;
        }
        int length = (position + 1) / 2;
        if ((position + 1) % 2 == 1) {
            length = position / 2 + 1;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = (int)this.histogram[i << 1] << 4;
            this.tmp |= (int)this.histogram[(i << 1) + 1];
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        if (in.length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, in.length << 1, this.histogram.length - 1, 0.0);
        }
        for (int i = 0; i < in.length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i << 1) + 1] = this.tmp & 0xF;
            this.histogram[i << 1] = this.tmp >> 4;
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        if (length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, length << 1, this.histogram.length - 1, 0.0);
        }
        for (int i = offset; i < offset + length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i - offset << 1) + 1] = this.tmp & 0xF;
            this.histogram[i - offset << 1] = this.tmp >> 4;
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.histogram;
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof SPFCTH)) {
            return -1.0f;
        }
        return (float)MetricsUtils.tanimoto(this.histogram, feature.getDoubleHistogram());
    }

    @Override
    public String getStringRepresentation() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public void setStringRepresentation(String s) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public String getFeatureName() {
        return "FCTH Spatial Pyramid";
    }

    @Override
    public String getFieldName() {
        return "f_spfcth";
    }
}

