/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import com.stromberglabs.jopensurf.SURFInterestPoint;
import com.stromberglabs.jopensurf.Surf;
import java.awt.image.BufferedImage;
import java.util.List;
import net.semanticmetadata.lire.AbstractDocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.SurfFeature;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;

public class SurfDocumentBuilder
extends AbstractDocumentBuilder {
    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        Field[] result = null;
        Surf s = new Surf(image);
        List interestPoints = s.getFreeOrientedInterestPoints();
        result = new Field[interestPoints.size()];
        int count = 0;
        for (SURFInterestPoint sip : interestPoints) {
            SurfFeature sf = new SurfFeature(sip);
            result[count] = new StoredField("featureSurf", sf.getByteArrayRepresentation());
            ++count;
        }
        return result;
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) {
        Document doc = null;
        Surf s = new Surf(image);
        List interestPoints = s.getFreeOrientedInterestPoints();
        doc = new Document();
        for (SURFInterestPoint sip : interestPoints) {
            SurfFeature sf = new SurfFeature(sip);
            doc.add((IndexableField)new StoredField("featureSurf", sf.getByteArrayRepresentation()));
        }
        if (identifier != null) {
            doc.add((IndexableField)new StringField("descriptorImageIdentifier", identifier, Field.Store.YES));
        }
        return doc;
    }
}

