/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.CEDD;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.GenericImageSearcher;
import net.semanticmetadata.lire.indexing.ProgressIndicator;
import net.semanticmetadata.lire.utils.LuceneUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;

public class MetricSpacesInvertedListIndexing {
    public static int numReferenceObjects = 500;
    public static int numReferenceObjectsUsed = 50;
    private static MetricSpacesInvertedListIndexing msili = new MetricSpacesInvertedListIndexing(CEDD.class, "featureCEDD");
    private Class<? extends LireFeature> featureClass;
    private String featureFieldName;
    private int numHits = 100;
    private ProgressIndicator progress;

    public MetricSpacesInvertedListIndexing(Class<? extends LireFeature> featureClass, String featureFieldName) {
        this.featureClass = featureClass;
        this.featureFieldName = featureFieldName;
        this.progress = new ProgressIndicator();
    }

    public static MetricSpacesInvertedListIndexing getDefaultInstance() {
        return msili;
    }

    public void createIndex(String indexPath) throws IOException {
        DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath)));
        int numDocs = reader.numDocs();
        if (numDocs < numReferenceObjects) {
            throw new UnsupportedOperationException("Too few documents in index.");
        }
        this.progress.setNumDocsAll(numDocs);
        this.progress.setCurrentState(State.RoSelection);
        boolean hasDeletions = reader.hasDeletions();
        IndexWriter iw = LuceneUtils.createIndexWriter(indexPath + "-ro", true);
        HashSet<Integer> referenceObjsIds = new HashSet<Integer>(numReferenceObjects);
        double numDocsDouble = numDocs;
        while (referenceObjsIds.size() < numReferenceObjects) {
            referenceObjsIds.add((int)(numDocsDouble * Math.random()));
        }
        int count = 0;
        if (hasDeletions) {
            System.err.println("WARNING: There are deleted docs in your index. You should optimize your index before using this method.");
        }
        this.progress.setCurrentState(State.RoIndexing);
        Iterator i$ = referenceObjsIds.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            Document document = reader.document(i);
            document.add((IndexableField)new Field("ro-id", ++count + "", StringField.TYPE_STORED));
            iw.addDocument((Iterable)document);
        }
        iw.commit();
        iw.close();
        this.progress.setCurrentState(State.Indexing);
        DirectoryReader readerRo = DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath + "-ro")));
        GenericImageSearcher searcher = new GenericImageSearcher(numReferenceObjectsUsed, this.featureClass, this.featureFieldName);
        HashMap<String, WhitespaceAnalyzer> analyzerPerField = new HashMap<String, WhitespaceAnalyzer>();
        analyzerPerField.put("ro-order", new WhitespaceAnalyzer(LuceneUtils.LUCENE_VERSION));
        PerFieldAnalyzerWrapper aWrapper = new PerFieldAnalyzerWrapper((Analyzer)new SimpleAnalyzer(LuceneUtils.LUCENE_VERSION), analyzerPerField);
        iw = new IndexWriter((Directory)FSDirectory.open((File)new File(indexPath)), new IndexWriterConfig(LuceneUtils.LUCENE_VERSION, (Analyzer)aWrapper).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        StringBuilder sb = new StringBuilder(256);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < numDocs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            Document document = reader.document(i);
            ImageSearchHits hits = searcher.search(document, (IndexReader)readerRo);
            sb.delete(0, sb.length());
            for (int j = 0; j < numReferenceObjectsUsed; ++j) {
                sb.append(hits.doc(j).getValues("ro-id")[0]);
                sb.append(' ');
            }
            document.add((IndexableField)new TextField("ro-order", sb.toString(), Field.Store.YES));
            iw.updateDocument(new Term("descriptorImageIdentifier", document.getValues("descriptorImageIdentifier")[0]), (Iterable)document);
            this.progress.setNumDocsProcessed(this.progress.getNumDocsProcessed() + 1);
        }
        iw.commit();
        iw.close();
        this.progress.setCurrentState(State.Idle);
    }

    public void updateIndex(String indexPath) throws IOException {
        DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath)));
        int numDocs = reader.numDocs();
        boolean hasDeletions = reader.hasDeletions();
        int countUpdated = 0;
        DirectoryReader readerRo = DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath + "-ro")));
        GenericImageSearcher searcher = new GenericImageSearcher(numReferenceObjectsUsed, this.featureClass, this.featureFieldName);
        HashMap<String, WhitespaceAnalyzer> perField = new HashMap<String, WhitespaceAnalyzer>(1);
        perField.put("ro-order", new WhitespaceAnalyzer(LuceneUtils.LUCENE_VERSION));
        PerFieldAnalyzerWrapper aWrapper = new PerFieldAnalyzerWrapper((Analyzer)new SimpleAnalyzer(LuceneUtils.LUCENE_VERSION), perField);
        IndexWriter iw = new IndexWriter((Directory)FSDirectory.open((File)new File(indexPath)), new IndexWriterConfig(LuceneUtils.LUCENE_VERSION, (Analyzer)aWrapper).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        StringBuilder sb = new StringBuilder(256);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < numDocs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            Document document = reader.document(i);
            if (document.getField("ro-order") == null) {
                ImageSearchHits hits = searcher.search(document, (IndexReader)readerRo);
                sb.delete(0, sb.length());
                for (int j = 0; j < numReferenceObjectsUsed; ++j) {
                    sb.append(hits.doc(j).getValues("ro-id")[0]);
                    sb.append(' ');
                }
                document.add((IndexableField)new TextField("ro-order", sb.toString(), Field.Store.YES));
                iw.updateDocument(new Term("descriptorImageIdentifier", document.getValues("descriptorImageIdentifier")[0]), (Iterable)document);
                ++countUpdated;
            }
            this.progress.setNumDocsProcessed(this.progress.getNumDocsProcessed() + 1);
            System.out.println("countUpdated = " + countUpdated);
        }
        iw.commit();
        iw.close();
    }

    public TopDocs search(BufferedImage img, String indexPath) throws IOException {
        GenericImageSearcher searcher = new GenericImageSearcher(numReferenceObjectsUsed, this.featureClass, this.featureFieldName);
        ImageSearchHits hits = searcher.search(img, (IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath + "-ro"))));
        StringBuilder sb = new StringBuilder(numReferenceObjectsUsed * 4);
        for (int j = 0; j < numReferenceObjectsUsed; ++j) {
            sb.append(hits.doc(j).getValues("ro-id")[0]);
            sb.append(' ');
        }
        return this.scoreDocs(sb.toString(), (IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath))));
    }

    public TopDocs search(Document d, String indexPath) throws IOException {
        if (d.getField("ro-order") != null) {
            return this.scoreDocs(d.getValues("ro-order")[0], (IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath))));
        }
        GenericImageSearcher searcher = new GenericImageSearcher(numReferenceObjectsUsed, this.featureClass, this.featureFieldName);
        ImageSearchHits hits = searcher.search(d, (IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath + "-ro"))));
        StringBuilder sb = new StringBuilder(numReferenceObjectsUsed * 4);
        for (int j = 0; j < numReferenceObjectsUsed; ++j) {
            sb.append(hits.doc(j).getValues("ro-id")[0]);
            sb.append(' ');
        }
        return this.scoreDocs(sb.toString(), (IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath))));
    }

    protected TopDocs scoreDocs(String queryString, IndexReader reader) throws IOException {
        throw new UnsupportedOperationException("Not supported currently in Lucene 4.0");
    }

    public int getNumHits() {
        return this.numHits;
    }

    public void setNumHits(int numHits) {
        this.numHits = numHits;
    }

    public IndexReader getIndexReader(String indexPath) throws IOException {
        return DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexPath)));
    }

    public ProgressIndicator getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressIndicator progress) {
        this.progress = progress;
    }

    private static class ScoreDocComparator
    implements Comparator<ScoreDoc> {
        private ScoreDocComparator() {
        }

        @Override
        public int compare(ScoreDoc o1, ScoreDoc o2) {
            return (int)Math.signum(o2.score - o1.score);
        }
    }

    public static enum State {
        RoSelection,
        RoIndexing,
        Indexing,
        Idle;

    }
}

