/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing.fastmap;

import net.semanticmetadata.lire.indexing.fastmap.FastmapDistanceMatrix;

public class FastMap
implements Runnable {
    private double[][] X;
    private int[][] PA;
    private boolean predefinedPivots = false;
    private int col;
    private int currentDimension;
    private FastmapDistanceMatrix matrixFastmap;
    int dimensions;

    public FastMap(FastmapDistanceMatrix matrixFastmap, int dimensions) {
        this.matrixFastmap = matrixFastmap;
        this.dimensions = dimensions;
        this.init();
    }

    public FastMap(FastmapDistanceMatrix matrixFastmap, int dimensions, int[][] pivots) {
        this.matrixFastmap = matrixFastmap;
        this.dimensions = dimensions;
        this.init();
        this.predefinedPivots = true;
        this.PA = pivots;
    }

    private void init() {
        this.X = new double[this.matrixFastmap.getDimension()][this.dimensions];
        this.PA = new int[2][this.dimensions];
        this.col = 0;
        this.currentDimension = 0;
    }

    public double[][] getPoints() {
        return this.X;
    }

    @Override
    public void run() {
        while (this.fastMap() > 0) {
        }
    }

    private int fastMap() {
        int pivot2;
        int pivot1;
        int k = this.dimensions - this.currentDimension;
        if (k <= 0) {
            return 0;
        }
        ++this.col;
        if (!this.predefinedPivots) {
            this.findPivots(k);
        }
        if (this.matrixFastmap.getDistance(pivot1 = this.PA[0][k - 1], pivot2 = this.PA[1][k - 1], this.currentDimension, this.X[pivot1], this.X[pivot2]) == 0.0) {
            for (int i = 0; i < this.X.length; ++i) {
                double[] floats = this.X[i];
                floats[this.col - 1] = 0.0;
            }
            return 0;
        }
        for (int i = 0; i < this.matrixFastmap.getDimension(); ++i) {
            double d_ab2 = this.matrixFastmap.getDistance(pivot1, pivot2, this.currentDimension, this.X[pivot1], this.X[pivot2]);
            double d_ai2 = this.matrixFastmap.getDistance(pivot1, i, this.currentDimension, this.X[pivot1], this.X[i]);
            double d_bi2 = this.matrixFastmap.getDistance(pivot2, i, this.currentDimension, this.X[pivot2], this.X[i]);
            this.X[i][this.col - 1] = (d_ai2 * d_ai2 + d_ab2 * d_ab2 - d_bi2 * d_bi2) / (2.0 * d_ab2);
        }
        ++this.currentDimension;
        return k - 1;
    }

    private void findPivots(int k) {
        int numIterations = 4;
        int randomRow = (int)(Math.random() * (double)this.matrixFastmap.getDimension());
        int pivot1 = 0;
        int pivot2 = randomRow;
        for (int i = 0; i < numIterations; ++i) {
            pivot1 = this.matrixFastmap.getMaximumDistance(pivot2, this.currentDimension, this.X);
            pivot2 = this.matrixFastmap.getMaximumDistance(pivot1, this.currentDimension, this.X);
        }
        this.PA[1][k - 1] = pivot2;
        this.PA[0][k - 1] = pivot1;
    }

    public int getIndexOfObject(Object o) {
        return this.matrixFastmap.getIndexOfObject(o);
    }

    public int[][] getPivots() {
        return this.PA;
    }
}

