/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.TopDocs;

public class FileUtils {
    public static ArrayList<String> getAllImages(File directory, boolean descendIntoSubDirectories) throws IOException {
        File[] f;
        ArrayList<String> resultList = new ArrayList<String>(256);
        for (File file : f = directory.listFiles()) {
            ArrayList<String> tmp;
            if (file != null && (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif")) && !file.getName().startsWith("tn_")) {
                resultList.add(file.getCanonicalPath());
            }
            if (!descendIntoSubDirectories || !file.isDirectory() || (tmp = FileUtils.getAllImages(file, true)) == null) continue;
            resultList.addAll(tmp);
        }
        if (resultList.size() > 0) {
            return resultList;
        }
        return null;
    }

    public static ArrayList<File> getAllImageFiles(File directory, boolean descendIntoSubDirectories) throws IOException {
        File[] f;
        ArrayList<File> resultList = new ArrayList<File>(256);
        for (File file : f = directory.listFiles()) {
            ArrayList<File> tmp;
            if (file != null && (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".png")) && !file.getName().startsWith("tn_")) {
                resultList.add(file);
            }
            if (!descendIntoSubDirectories || !file.isDirectory() || (tmp = FileUtils.getAllImageFiles(file, true)) == null) continue;
            resultList.addAll(tmp);
        }
        if (resultList.size() > 0) {
            return resultList;
        }
        return null;
    }

    public static String saveImageResultsToHtml(String prefix, ImageSearchHits hits, String queryImage) throws IOException {
        long l = System.currentTimeMillis() / 1000L;
        String fileName = "results-" + prefix + "-" + l + ".html";
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        bw.write("<html>\n<head><title>Search Results</title></head>\n<body bgcolor=\"#FFFFFF\">\n");
        bw.write("<h3>query</h3>\n");
        bw.write("<a href=\"file://" + queryImage + "\"><img src=\"file://" + queryImage + "\"></a><p>\n");
        bw.write("<h3>results</h3>\n");
        for (int i = 0; i < hits.length(); ++i) {
            bw.write(hits.score(i) + " - <a href=\"file://" + hits.doc(i).get("descriptorImageIdentifier") + "\"><img src=\"file://" + hits.doc(i).get("descriptorImageIdentifier") + "\"></a><p>\n");
        }
        bw.write("</body>\n</html>");
        bw.close();
        return fileName;
    }

    public static String saveImageResultsToHtml(String prefix, TopDocs hits, IndexReader reader, String queryImage) throws IOException {
        long l = System.currentTimeMillis() / 1000L;
        String fileName = "results-" + prefix + "-" + l + ".html";
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        bw.write("<html>\n<head><title>Search Results</title></head>\n<body bgcolor=\"#FFFFFF\">\n");
        bw.write("<h3>query</h3>\n");
        bw.write("<a href=\"file://" + queryImage + "\"><img src=\"file://" + queryImage + "\"></a><p>\n");
        bw.write("<h3>results</h3>\n");
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            bw.write(hits.scoreDocs[i].score + " - <a href=\"file://" + reader.document(hits.scoreDocs[i].doc).get("descriptorImageIdentifier") + "\"><img src=\"file://" + reader.document(hits.scoreDocs[i].doc).get("descriptorImageIdentifier") + "\"></a><p>\n");
        }
        bw.write("</body>\n</html>");
        bw.close();
        return fileName;
    }

    public static void browseUri(String uri) {
        Desktop desktop;
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported (fatal)");
            System.exit(1);
        }
        if (!(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop doesn't support the browse action (fatal)");
            System.exit(1);
        }
        try {
            URI url = new URI(uri);
            desktop.browse(url);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void saveImageResultsToPng(String prefix, ImageSearchHits hits, String queryImage) throws IOException {
        LinkedList<BufferedImage> results = new LinkedList<BufferedImage>();
        int width = 0;
        for (int i = 0; i < hits.length(); ++i) {
            BufferedImage tmp = ImageIO.read(new FileInputStream(hits.doc(i).get("descriptorImageIdentifier")));
            double factor = 200.0 / (double)tmp.getHeight();
            tmp = ImageUtils.scaleImage(tmp, (int)((double)tmp.getWidth() * factor), 200);
            width += tmp.getWidth() + 5;
            results.add(tmp);
        }
        BufferedImage result = new BufferedImage(width, 220, 1);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.setColor(Color.white);
        g2.setBackground(Color.white);
        g2.clearRect(0, 0, result.getWidth(), result.getHeight());
        g2.setColor(Color.black);
        g2.setFont(Font.decode("\"Arial\", Font.BOLD, 12"));
        int offset = 0;
        int count = 0;
        for (BufferedImage next : results) {
            g2.drawImage((Image)next, offset, 20, null);
            g2.drawString(hits.score(count) + "", offset + 5, 12);
            offset += next.getWidth() + 5;
            ++count;
        }
        ImageIO.write((RenderedImage)result, "PNG", new File(prefix + "_" + System.currentTimeMillis() / 1000L + ".png"));
    }

    public static void saveImageResultsToPng(String prefix, TopDocs hits, String queryImage, IndexReader ir) throws IOException {
        LinkedList<BufferedImage> results = new LinkedList<BufferedImage>();
        int width = 0;
        for (int i = 0; i < Math.min(hits.scoreDocs.length, 10); ++i) {
            BufferedImage tmp = ImageIO.read(new FileInputStream(ir.document(hits.scoreDocs[i].doc).get("descriptorImageIdentifier")));
            if (tmp.getHeight() > 200) {
                double factor = 200.0 / (double)tmp.getHeight();
                tmp = ImageUtils.scaleImage(tmp, (int)((double)tmp.getWidth() * factor), 200);
            }
            width += tmp.getWidth() + 5;
            results.add(tmp);
        }
        BufferedImage result = new BufferedImage(width, 220, 1);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.setColor(Color.black);
        g2.clearRect(0, 0, result.getWidth(), result.getHeight());
        g2.setColor(Color.green);
        g2.setFont(Font.decode("\"Arial\", Font.BOLD, 12"));
        int offset = 0;
        int count = 0;
        for (BufferedImage next : results) {
            g2.drawImage((Image)next, offset, 20, null);
            g2.drawString(hits.scoreDocs[count].score + "", offset + 5, 12);
            offset += next.getWidth() + 5;
            ++count;
        }
        ImageIO.write((RenderedImage)result, "PNG", new File(prefix + "_" + System.currentTimeMillis() / 1000L + ".png"));
    }

    public static void zipDirectory(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                FileUtils.zipDirectory(files[i], base, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1));
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileTypes identifyFileType(File file) throws IOException {
        byte[] buffer = new byte[8];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ((InputStream)in).read(buffer);
            if (buffer[0] == -119 && buffer[1] == 80 && buffer[2] == 78 && buffer[3] == 71) {
                FileTypes fileTypes = FileTypes.PNG;
                return fileTypes;
            }
            if (buffer[0] == 255 && buffer[1] == 216) {
                FileTypes fileTypes = FileTypes.JPG;
                return fileTypes;
            }
            if (buffer[0] == 37 && buffer[1] == 80 && buffer[2] == 68 && buffer[3] == 70) {
                FileTypes fileTypes = FileTypes.PDF;
                return fileTypes;
            }
            if (buffer[0] == 73 && buffer[1] == 73 && buffer[2] == 42 && buffer[3] == 0) {
                FileTypes fileTypes = FileTypes.TIF;
                return fileTypes;
            }
            if (buffer[0] == 77 && buffer[1] == 77 && buffer[2] == 0 && buffer[3] == 42) {
                FileTypes fileTypes = FileTypes.TIF;
                return fileTypes;
            }
            if (buffer[0] == 71 && buffer[1] == 73 && buffer[2] == 70 && buffer[3] == 56) {
                FileTypes fileTypes = FileTypes.GIF;
                return fileTypes;
            }
            FileTypes fileTypes = FileTypes.UNKNOWN;
            return fileTypes;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public static boolean isImageFileCompatible(File f) {
        boolean result = true;
        try {
            BufferedImage img = ImageIO.read(f);
            ColorLayout cl = new ColorLayout();
            cl.extract(img);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    static enum FileTypes {
        JPG,
        GIF,
        TIF,
        PNG,
        PDF,
        UNKNOWN;

    }
}

