/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

import java.io.File;
import java.io.IOException;
import net.semanticmetadata.lire.indexing.LireCustomCodec;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneUtils {
    public static final Version LUCENE_VERSION = Version.LUCENE_42;

    public static IndexWriter createIndexWriter(String indexPath, boolean create, AnalyzerType analyzer) throws IOException {
        return LuceneUtils.createIndexWriter((Directory)FSDirectory.open((File)new File(indexPath)), create, analyzer);
    }

    public static IndexWriter createIndexWriter(Directory directory, boolean create, AnalyzerType analyzer) throws IOException {
        SimpleAnalyzer tmpAnalyzer = null;
        if (analyzer == AnalyzerType.SimpleAnalyzer) {
            tmpAnalyzer = new SimpleAnalyzer(LUCENE_VERSION);
        } else if (analyzer == AnalyzerType.WhitespaceAnalyzer) {
            tmpAnalyzer = new WhitespaceAnalyzer(LUCENE_VERSION);
        } else if (analyzer == AnalyzerType.KeywordAnalyzer) {
            tmpAnalyzer = new KeywordAnalyzer();
        }
        IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)tmpAnalyzer);
        if (create) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        config.setCodec((Codec)new LireCustomCodec());
        return new IndexWriter(directory, config);
    }

    public static IndexWriter createIndexWriter(Directory directory, boolean create, AnalyzerType analyzer, double RAMBufferSize) throws IOException {
        SimpleAnalyzer tmpAnalyzer = null;
        if (analyzer == AnalyzerType.SimpleAnalyzer) {
            tmpAnalyzer = new SimpleAnalyzer(LUCENE_VERSION);
        } else if (analyzer == AnalyzerType.WhitespaceAnalyzer) {
            tmpAnalyzer = new WhitespaceAnalyzer(LUCENE_VERSION);
        }
        IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)tmpAnalyzer);
        if (create) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        config.setRAMBufferSizeMB(RAMBufferSize);
        config.setCodec((Codec)new LireCustomCodec());
        return new IndexWriter(directory, config);
    }

    public static IndexWriter createIndexWriter(String indexPath, boolean create) throws IOException {
        return LuceneUtils.createIndexWriter(indexPath, create, AnalyzerType.SimpleAnalyzer);
    }

    public static byte[] getBytes(BytesRef byteRef) {
        byte[] result = new byte[byteRef.length];
        System.arraycopy(byteRef.bytes, byteRef.offset, result, 0, byteRef.length);
        return result;
    }

    public static enum AnalyzerType {
        SimpleAnalyzer,
        WhitespaceAnalyzer,
        KeywordAnalyzer;

    }
}

