/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateTime;
import adams.core.Utils;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.WindowedSpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;

public class AccessSpreadSheetReader
extends AbstractSpreadSheetReader
implements ChunkedSpreadSheetReader,
WindowedSpreadSheetReader {
    private static final long serialVersionUID = 1822931227110464391L;
    protected String m_Table;
    protected int m_FirstRow;
    protected int m_NumRows;
    protected int m_ChunkSize;
    protected ChunkReader m_Reader;

    public String globalInfo() {
        return "Allows the reading of MS Access databases.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("table", "table", (Object)"MyTable");
        this.m_OptionManager.add("first-row", "firstRow", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    protected void reset() {
        super.reset();
        this.m_Reader = null;
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The table to read from the database.";
    }

    public void setFirstRow(int value) {
        if (value > 0) {
            this.m_FirstRow = value;
            this.reset();
        } else {
            this.getLogger().warning("First row must be > 0, provided: " + value);
        }
    }

    public int getFirstRow() {
        return this.m_FirstRow;
    }

    public String firstRowTipText() {
        return "The index of the first row to retrieve (1-based).";
    }

    public void setNumRows(int value) {
        this.m_NumRows = value < 0 ? -1 : value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of data rows to retrieve; use -1 for unlimited.";
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return null;
    }

    public String getFormatDescription() {
        return "MS Access database";
    }

    public String[] getFormatExtensions() {
        return new String[]{".mdb", ".accdb"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    protected SpreadSheet doRead(File file) {
        SpreadSheet result;
        try {
            Database db = DatabaseBuilder.open((File)file.getAbsoluteFile());
            this.m_Reader = new ChunkReader(this);
            result = this.m_Reader.read(db.getTable(this.m_Table));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to open database: " + file, e);
            result = null;
        }
        return result;
    }

    public boolean hasMoreChunks() {
        return this.m_Reader != null && this.m_Reader.hasNext();
    }

    public SpreadSheet nextChunk() {
        if (this.m_Reader == null || !this.m_Reader.hasNext()) {
            return null;
        }
        return this.m_Reader.next();
    }

    public static class ChunkReader
    implements Serializable {
        protected AccessSpreadSheetReader m_Owner;
        protected Table m_Table;
        protected SpreadSheet m_Header;
        protected int m_ChunkSize;
        protected int m_RowCount;
        protected int m_FirstRow;
        protected int m_NumRows;

        public ChunkReader(AccessSpreadSheetReader owner) {
            this.m_Owner = owner;
        }

        public SpreadSheet next() {
            HeaderRow row;
            SpreadSheet result;
            List cols = this.m_Table.getColumns();
            if (this.m_Header == null) {
                result = this.m_Owner.getSpreadSheetType().newInstance();
                result.setDataRowClass(this.m_Owner.getDataRowType().getClass());
                row = result.getHeaderRow();
                for (Column col : cols) {
                    row.addCell(col.getName()).setContent(col.getName());
                }
            } else {
                result = this.m_Header.getHeader();
            }
            boolean first = this.m_Header == null;
            try {
                while (!this.m_Owner.isStopped()) {
                    Row aRow;
                    block27: {
                        try {
                            aRow = this.m_Table.getNextRow();
                            if (aRow == null) {
                                this.close();
                            }
                            break block27;
                        }
                        catch (Exception e) {
                            this.close();
                        }
                        break;
                    }
                    boolean canAdd = true;
                    ++this.m_RowCount;
                    if (this.m_RowCount < this.m_FirstRow) {
                        canAdd = false;
                    }
                    if (canAdd) {
                        row = result.addRow();
                        block18: for (Column col : cols) {
                            Cell cell = row.addCell(col.getName());
                            cell.isMissing();
                            try {
                                switch (col.getType()) {
                                    case BOOLEAN: {
                                        cell.setContent(aRow.getBoolean(col.getName()));
                                        break;
                                    }
                                    case BYTE: {
                                        cell.setContent(aRow.getByte(col.getName()));
                                        break;
                                    }
                                    case DOUBLE: 
                                    case NUMERIC: {
                                        cell.setContent(aRow.getDouble(col.getName()));
                                        break;
                                    }
                                    case FLOAT: {
                                        cell.setContent(aRow.getFloat(col.getName()));
                                        break;
                                    }
                                    case INT: {
                                        cell.setContent(aRow.getShort(col.getName()));
                                        break;
                                    }
                                    case LONG: {
                                        cell.setContent(aRow.getInt(col.getName()));
                                        break;
                                    }
                                    case MEMO: 
                                    case TEXT: {
                                        cell.setContent(aRow.getString(col.getName()));
                                        break;
                                    }
                                    case SHORT_DATE_TIME: {
                                        if (aRow.getDate(col.getName()) == null) continue block18;
                                        cell.setContent(new DateTime(aRow.getDate(col.getName())));
                                        break;
                                    }
                                    default: {
                                        if (!first) continue block18;
                                        this.m_Owner.getLogger().warning("Unsupported data type: " + col.getType() + " ('" + this.m_Owner.getTable() + "'/'" + col.getName() + "')");
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                this.m_Owner.getLogger().log(Level.SEVERE, "Failed to process table/row/column: '" + this.m_Owner.getTable() + "'/" + result.getRowCount() + "/'" + col.getName(), e);
                            }
                        }
                        first = false;
                    }
                    if (this.m_Header == null) {
                        this.m_Header = result.getHeader();
                    }
                    if (this.m_NumRows > -1 && this.m_RowCount >= this.m_FirstRow + this.m_NumRows - 1) {
                        this.close();
                    } else if (this.m_ChunkSize <= 0 || result.getRowCount() != this.m_ChunkSize) continue;
                    break;
                }
            }
            catch (Exception e) {
                result = null;
                this.m_Owner.getLogger().log(Level.SEVERE, "Failed to read data!", e);
                this.m_Owner.setLastError("Failed to read data!\n" + Utils.throwableToString((Throwable)e));
            }
            return result;
        }

        protected void close() {
            try {
                this.m_Table.getDatabase().close();
                this.m_Table = null;
            }
            catch (Exception e) {
                this.m_Owner.getLogger().log(Level.SEVERE, "Failed to read data!", e);
                this.m_Owner.setLastError("Failed to read data!\n" + Utils.throwableToString((Throwable)e));
            }
        }

        public boolean hasNext() {
            return this.m_Table != null;
        }

        public SpreadSheet read(Table table) {
            this.m_Table = table;
            this.m_Header = null;
            this.m_ChunkSize = this.m_Owner.getChunkSize();
            this.m_FirstRow = this.m_Owner.getFirstRow();
            this.m_NumRows = this.m_Owner.getNumRows();
            this.m_RowCount = 0;
            return this.next();
        }
    }
}

