/*
 * Decompiled with CFR 0.152.
 */
package mst;

import java.util.Random;
import mst.Edge;
import mst.EdgeWeightedGraph;
import mst.MinPQ;
import mst.Queue;
import mst.StdOut;
import mst.UF;

public class KruskalMST {
    private double weight;
    private Queue<Edge> mst = new Queue();

    public KruskalMST(EdgeWeightedGraph G) {
        MinPQ<Edge> pq = new MinPQ<Edge>();
        for (Edge e : G.edges()) {
            pq.insert(e);
        }
        UF uf = new UF(G.V());
        while (!pq.isEmpty() && this.mst.size() < G.V() - 1) {
            int w;
            Edge e;
            e = (Edge)pq.delMin();
            int v = e.either();
            if (uf.connected(v, w = e.other(v))) continue;
            uf.union(v, w);
            this.mst.enqueue(e);
            this.weight += e.weight();
        }
        assert (this.check(G));
    }

    public Iterable<Edge> edges() {
        return this.mst;
    }

    public double weight() {
        return this.weight;
    }

    private boolean check(EdgeWeightedGraph G) {
        int w;
        int v;
        double total = 0.0;
        for (Edge e : this.edges()) {
            total += e.weight();
        }
        double EPSILON = 1.0E-12;
        if (Math.abs(total - this.weight()) > EPSILON) {
            System.err.printf("Weight of edges does not equal weight(): %f vs. %f\n", total, this.weight());
            return false;
        }
        UF uf = new UF(G.V());
        for (Edge e : this.edges()) {
            v = e.either();
            if (uf.connected(v, w = e.other(v))) {
                System.err.println("Not a forest");
                return false;
            }
            uf.union(v, w);
        }
        for (Edge e : this.edges()) {
            v = e.either();
            if (uf.connected(v, w = e.other(v))) continue;
            System.err.println("Not a spanning forest");
            return false;
        }
        for (Edge e : this.edges()) {
            int y;
            int x;
            v = e.either();
            w = e.other(v);
            uf = new UF(G.V());
            for (Edge f : this.mst) {
                x = f.either();
                y = f.other(x);
                if (f == e) continue;
                uf.union(x, y);
            }
            for (Edge f : G.edges()) {
                x = f.either();
                if (uf.connected(x, y = f.other(x)) || !(f.weight() < e.weight())) continue;
                System.err.println("Edge " + f + " violates cut optimality conditions");
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        Random r = new Random();
        EdgeWeightedGraph G = new EdgeWeightedGraph(8);
        for (int i = 0; i < 8; ++i) {
            for (int j = i + 1; j < 8; ++j) {
                Edge e = new Edge(i, j, r.nextDouble());
                G.addEdge(e);
            }
        }
        KruskalMST mst = new KruskalMST(G);
        for (Edge e : mst.edges()) {
            StdOut.println(e);
        }
        StdOut.printf("%.5f\n", mst.weight());
    }
}

