/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter;

import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapterRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.misc.Service;

public class StandardGraphicsEnvironmentAdapterRegistry
implements IGraphicsEnvironmentAdapterRegistry {
    private boolean lookupProviders = true;
    private Map<IGraphicsEnvironment, IGraphicsEnvironmentAdapter> adapters = new HashMap<IGraphicsEnvironment, IGraphicsEnvironmentAdapter>();
    private boolean initialized = false;

    protected IGraphicsEnvironmentAdapter[] findProviders() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = IGraphicsEnvironmentAdapter.class.getClassLoader();
        }
        Iterator ps = Service.providers(IGraphicsEnvironmentAdapter.class, (ClassLoader)loader);
        ArrayList<IGraphicsEnvironmentAdapter> adapters = new ArrayList<IGraphicsEnvironmentAdapter>();
        while (ps.hasNext()) {
            try {
                adapters.add((IGraphicsEnvironmentAdapter)ps.next());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return adapters.toArray(new IGraphicsEnvironmentAdapter[adapters.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IGraphicsEnvironmentAdapter[] adapters = this.findProviders();
        int i = 0;
        while (i < adapters.length) {
            this.registerGraphicsEnvironmentAdapter(adapters[i].getGraphicsEnvironment(), adapters[i]);
            ++i;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    public synchronized IGraphicsEnvironmentAdapter lookupGraphicsEnvironmentAdapter(IGraphicsEnvironment environment) {
        this.init();
        IGraphicsEnvironmentAdapter adapter = this.adapters.get(environment);
        return adapter;
    }

    public synchronized void registerGraphicsEnvironmentAdapter(IGraphicsEnvironment environment, IGraphicsEnvironmentAdapter adapter) {
        this.adapters.put(environment, adapter);
    }

    public void setLookupProviders(boolean pLookupProviders) {
        this.lookupProviders = pLookupProviders;
    }
}

