/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.trigonometric;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Sin
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8127064720590287207L;

    public Sin(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return Math.sin(this.getSource().getAsDouble(coordinates));
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.sin(source.getAsDouble(c)), c);
        }
        return ret;
    }
}

