/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.IntelligentFileWriter;

public abstract class ExportMatrixCSV {
    private static String separator = "\t";

    public static void toFile(File file, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        IntelligentFileWriter writer = new IntelligentFileWriter(file);
        ExportMatrixCSV.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        ExportMatrixCSV.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toWriter(Writer writer, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        String lineend = System.getProperty("line.separator");
        long rowCount = matrix.getRowCount();
        long colCount = matrix.getColumnCount();
        int row = 0;
        while ((long)row < rowCount) {
            int col = 0;
            while ((long)col < colCount) {
                writer.append("" + matrix.getAsObject(row, col));
                if ((long)col < colCount - 1L) {
                    writer.append(separator);
                }
                ++col;
            }
            if ((long)row < rowCount - 1L) {
                writer.append(lineend);
            }
            ++row;
        }
    }
}

