/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.frame;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.gui.io.ExportPNG;
import org.ujmp.gui.statusbar.StatusBar;
import org.ujmp.gui.util.FrameManager;
import org.ujmp.gui.util.GlobalTimer;
import org.ujmp.gui.util.GraphicsExecutor;
import org.ujmp.gui.util.UIDefaults;

public abstract class AbstractFrame
extends JFrame {
    private static final long serialVersionUID = -4656308453503586700L;
    private int modCount = -1;
    private GUIObject object = null;
    private StatusBar statusBar = null;
    private static int frameCount = 0;
    private TimerTask updateTask = null;

    public AbstractFrame(GUIObject o, JComponent component) {
        String label;
        this.setDefaultCloseOperation(2);
        UIDefaults.setDefaults();
        FrameManager.registerFrame(o, this);
        this.object = o;
        String string = label = o.getLabel() == null ? "no label" : o.getLabel();
        if (o instanceof MatrixGUIObject) {
            MatrixGUIObject mgui = (MatrixGUIObject)o;
            Matrix m = mgui.getMatrix();
            String size = Coordinates.toString(m.getSize()).replaceAll(",", "x");
            this.setTitle("[" + size + "] " + m.getClass().getSimpleName() + " [" + label + "]");
        } else {
            this.setTitle(o.toString());
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (d.getHeight() < 800.0) {
            this.setPreferredSize(new Dimension(700, 500));
            this.setSize(new Dimension(700, 500));
            this.setExtendedState(6);
        } else if (d.getHeight() < 1024.0) {
            this.setPreferredSize(new Dimension(1000, 600));
            this.setSize(new Dimension(1000, 600));
            this.setExtendedState(6);
        } else {
            this.setPreferredSize(new Dimension(1280, 800));
            this.setSize(new Dimension(1280, 800));
        }
        this.statusBar = new StatusBar(this.object);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)component, "Center");
        final GUIObject go = this.object;
        this.updateTask = new TimerTask(){

            public void run() {
                if (AbstractFrame.this.modCount != go.getModCount()) {
                    AbstractFrame.this.modCount = go.getModCount();
                    AbstractFrame.this.repaint(1000L);
                }
            }
        };
        GlobalTimer.getInstance().scheduleAtFixedRate(this.updateTask, 1000L, 1000L);
    }

    public final void setVisible(boolean state) {
        if (state && this.isVisible()) {
            return;
        }
        if (!state && !this.isVisible()) {
            return;
        }
        super.setVisible(state);
        if (state) {
            ++frameCount;
            this.statusBar.start();
        } else {
            --frameCount;
            this.statusBar.stop();
        }
        if (frameCount == 0) {
            GraphicsExecutor.shutDown();
            GlobalTimer.shutDown();
        }
    }

    public final GUIObject getObject() {
        return this.object;
    }

    public final void exportToPDF(File file) {
        ExportPDF.save(file, this);
    }

    public final void exportToPNG(File file) {
        ExportPNG.save(file, (Component)this);
    }

    public final void exportToJPEG(File file) {
        ExportJPEG.save(file, (Component)this);
    }
}

