/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Properties;
import adams.env.Environment;

public class Performance {
    public static final String FILENAME = "Performance.props";
    protected static Properties m_Properties;

    protected static synchronized void initialize() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("performance");
        }
    }

    public static boolean getBoolean(String key, boolean defValue) {
        return m_Properties.getBoolean(key, defValue);
    }

    public static int getInteger(String key, int defValue) {
        return m_Properties.getInteger(key, defValue);
    }

    public static double getDouble(String key, double defValue) {
        return m_Properties.getDouble(key, defValue);
    }

    public static int getMaxNumProcessors() {
        Performance.initialize();
        return m_Properties.getInteger("maxNumProcessors", -1);
    }

    public static int getMinKeepJobComplete() {
        Performance.initialize();
        return m_Properties.getInteger("minKeepJobComplete", 50);
    }

    public static int getMaxKeepJobComplete() {
        Performance.initialize();
        return m_Properties.getInteger("maxKeepJobComplete", 100);
    }

    public static boolean getKeepOnlyFailedJobComplete() {
        Performance.initialize();
        return m_Properties.getBoolean("keepOnlyFailedJobComplete", true);
    }

    public static boolean getMultiProcessingEnabled() {
        Performance.initialize();
        return m_Properties.getBoolean("multiProcessingEnabled", true);
    }
}

