/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.AbstractNamedSetup;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class NamedSetup
extends AbstractNamedSetup
implements InputConsumer {
    private static final long serialVersionUID = 7481937312011223794L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Sink that executes an sink actor referenced by the specified named setup.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    protected String setUpNamedSetupActor() {
        String result = super.setUpNamedSetupActor();
        if (result == null && !ActorUtils.isSink(this.m_NamedSetupActor)) {
            result = "Named setup actor referenced by '" + this.m_Setup.getName() + "' is not a sink!";
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_NamedSetupActor != null) {
            return ((InputConsumer)((Object)this.m_NamedSetupActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    protected String preExecuteNamedSetupActorHook() {
        ((InputConsumer)((Object)this.m_NamedSetupActor)).input(this.m_InputToken);
        this.m_InputToken = null;
        return null;
    }
}

