/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.core.Properties;
import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.gui.core.ColorHelper;
import adams.gui.event.PlotPanelPanningEvent;
import adams.gui.event.PlotPanelPanningListener;
import adams.gui.event.PlotPanelZoomEvent;
import adams.gui.event.PlotPanelZoomListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.DataContainerZoomOverviewPaintlet;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Dimension;
import java.awt.Graphics;

public abstract class DataContainerZoomOverviewPanel<P extends DataContainerPanel, C extends Paintlet, Z extends DataContainerZoomOverviewPaintlet, T extends DataContainer, M extends ContainerManager>
extends DataContainerPanel<T, M>
implements PlotPanelZoomListener,
PlotPanelPanningListener {
    private static final long serialVersionUID = -5141649373267221710L;
    protected P m_ContainerPanel;
    protected C m_ContainerPaintlet;
    protected Z m_ZoomOverviewPaintlet;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ContainerPanel = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ContainerPaintlet = null;
        this.m_ZoomOverviewPaintlet = this.newZoomPaintlet();
        ((AbstractPaintlet)this.m_ZoomOverviewPaintlet).setPanel(this);
        this.m_PlotPanel.setZoomingEnabled(false);
        this.m_PlotPanel.setPanningEnabled(false);
        this.setVisible(false);
    }

    protected abstract Z newZoomPaintlet();

    @Override
    public DataContainerZoomOverviewPaintlet getContainerPaintlet() {
        return this.m_ZoomOverviewPaintlet;
    }

    public void setDataContainerPanel(P value) {
        if (this.m_ContainerPanel != null) {
            ((DataContainerPanel)this.m_ContainerPanel).getPlot().removeZoomListener(this);
            ((DataContainerPanel)this.m_ContainerPanel).getPlot().removePanningListener(this);
        }
        this.m_ContainerPanel = value;
        if (this.m_ContainerPanel != null) {
            Properties props = ((DataContainerPanel)this.m_ContainerPanel).getProperties();
            this.m_ContainerPaintlet = (Paintlet)((DataContainerPanel)this.m_ContainerPanel).getContainerPaintlet().shallowCopy();
            this.m_ContainerPaintlet.setPanel(this);
            AxisPanel panel = this.m_PlotPanel.getAxis(Axis.LEFT);
            panel.assign(((DataContainerPanel)this.m_ContainerPanel).getPlot().getAxis(Axis.LEFT));
            panel.setAxisName("Zoom view");
            panel.setShowOnlyMajorGridLines(true);
            panel.setNumTicks(5);
            panel.setNthValueToShow(0);
            panel = this.m_PlotPanel.getAxis(Axis.BOTTOM);
            panel.assign(((DataContainerPanel)this.m_ContainerPanel).getPlot().getAxis(Axis.BOTTOM));
            panel.setAxisName("");
            panel.setShowOnlyMajorGridLines(true);
            panel.setNthValueToShow(0);
            panel.setAxisWidth(20);
            this.m_PlotPanel.updateCorners();
            ((DataContainerZoomOverviewPaintlet)this.m_ZoomOverviewPaintlet).setHighlightColor(props.getColor("ZoomOverview.HighlightColor", ColorHelper.valueOf("#FFDDFF")));
            this.setVisible(props.getBoolean("ZoomOverview.Visible", false));
            this.setPreferredSize(new Dimension(0, props.getInteger("ZoomOverview.Height", 100)));
            ((DataContainerPanel)this.m_ContainerPanel).getPlot().addZoomListener(this);
            ((DataContainerPanel)this.m_ContainerPanel).getPlot().addPanningListener(this);
        }
        this.update();
    }

    public P getDataContainerPanel() {
        return this.m_ContainerPanel;
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return null;
    }

    @Override
    protected M newContainerManager() {
        return null;
    }

    @Override
    public AbstractScriptingEngine getScriptingEngine() {
        return null;
    }

    @Override
    public M getContainerManager() {
        if (this.m_ContainerPanel != null) {
            return ((DataContainerPanel)this.m_ContainerPanel).getContainerManager();
        }
        return null;
    }

    @Override
    protected void prepareUpdate() {
        if (this.getDataContainerPanel() == null) {
            return;
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(((DataContainerPanel)this.getDataContainerPanel()).getPlot().getAxis(Axis.LEFT).getMinimum());
        this.getPlot().getAxis(Axis.LEFT).setMaximum(((DataContainerPanel)this.getDataContainerPanel()).getPlot().getAxis(Axis.LEFT).getMaximum());
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(((DataContainerPanel)this.getDataContainerPanel()).getPlot().getAxis(Axis.BOTTOM).getMinimum());
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(((DataContainerPanel)this.getDataContainerPanel()).getPlot().getAxis(Axis.BOTTOM).getMaximum());
    }

    @Override
    protected boolean canPaint(Graphics g) {
        return this.getContainerManager() != null;
    }

    @Override
    public void painted(PlotPanelZoomEvent e) {
        this.update();
    }

    @Override
    public void panningOccurred(PlotPanelPanningEvent e) {
        this.update();
    }
}

