/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRegexToRange
extends AbstractTransformer {
    private static final long serialVersionUID = 2556622944506847666L;
    protected String m_Regex;
    protected boolean m_Invert;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regex", "regex", (Object)".*");
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("regex");
        String result = variable != null ? variable : this.m_Regex;
        if (this.m_Invert) {
            result = "! " + result;
        }
        return result;
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "invert matching sense of regular expression.";
    }

    public void setRegex(String value) {
        this.m_Regex = value;
        this.reset();
    }

    public String getRegex() {
        return this.m_Regex;
    }

    public String regexTipText() {
        return "The regular expression for attribute matching.";
    }

    public String globalInfo() {
        return "Produces a range string from a regular expression describing attributes.";
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected boolean match(String input) {
        boolean ret = input.matches(this.m_Regex);
        if (this.m_Invert) {
            return !ret;
        }
        return ret;
    }

    protected String doExecute() {
        String result = null;
        String range = "";
        Instances inst = this.m_InputToken.getPayload() instanceof Instances ? (Instances)this.m_InputToken.getPayload() : ((Instance)this.m_InputToken.getPayload()).dataset();
        int firstInRange = Integer.MIN_VALUE;
        int lastInRange = Integer.MIN_VALUE;
        int last = Integer.MIN_VALUE;
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (!this.match(inst.attribute(i).name())) continue;
            if (i == last + 1) {
                lastInRange = i;
            } else {
                if (firstInRange != Integer.MIN_VALUE) {
                    if (!range.equals("")) {
                        range = range + ",";
                    }
                    range = firstInRange - lastInRange == 0 ? range + "" + (firstInRange + 1) : range + "" + (firstInRange + 1) + "-" + (lastInRange + 1);
                }
                firstInRange = i;
                lastInRange = i;
            }
            last = i;
        }
        if (!range.equals("")) {
            range = range + ",";
        }
        range = firstInRange < 0 ? "" : (lastInRange < 0 || lastInRange == firstInRange ? range + "" + (firstInRange + 1) : range + "" + (firstInRange + 1) + "-" + (lastInRange + 1));
        this.m_OutputToken = new Token((Object)range);
        return result;
    }
}

