/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font.outlet;

import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.outlet.IFontQuery;

public class FontQuery
implements IFontQuery {
    private PDFont baseFont;
    private PDFontStyle overrideFontStyle = PDFontStyle.UNDEFINED;
    private String overrideFontType = null;
    private String overrideFontFamilyName;
    private String overrideFontName;
    private Encoding overrideEncoding;

    public FontQuery() {
    }

    public FontQuery(PDFont baseFont) {
        this.baseFont = baseFont;
    }

    public FontQuery(String fontName) {
        this.setOverrideFontName(fontName);
    }

    public FontQuery(String family, PDFontStyle style) {
        this.setOverrideFontFamilyName(family);
        this.setOverrideFontStyle(style);
    }

    public FontQuery(String family, String style) {
        this.setOverrideFontFamilyName(family);
        this.setOverrideFontStyle(PDFontStyle.getFontStyle(style));
    }

    protected boolean checkLastChar() {
        return this.getBaseFont() != null;
    }

    protected PDFont getBaseFont() {
        return this.baseFont;
    }

    public Encoding getEncoding() {
        if (this.getOverrideEncoding() == null) {
            if (this.getBaseFont() == null) {
                return null;
            }
            return this.getBaseFont().getEncoding();
        }
        return this.getOverrideEncoding();
    }

    public String getFontFamilyName() {
        if (this.getOverrideFontFamilyName() == null) {
            if (this.getBaseFont() == null) {
                return null;
            }
            return this.getBaseFont().getLookupFontFamilyName();
        }
        return this.getOverrideFontFamilyName();
    }

    public String getFontName() {
        if (this.getOverrideFontName() == null) {
            if (this.getBaseFont() == null || this.getOverrideFontFamilyName() == null || this.getOverrideFontStyle() == null) {
                return null;
            }
            return this.getBaseFont().getFontNameNormalized();
        }
        return this.getOverrideFontName();
    }

    public PDFontStyle getFontStyle() {
        if (this.getOverrideFontStyle() == PDFontStyle.UNDEFINED) {
            if (this.getBaseFont() == null) {
                return PDFontStyle.UNDEFINED;
            }
            return this.getBaseFont().getLookupFontStyle();
        }
        return this.getOverrideFontStyle();
    }

    public String getFontType() {
        if (this.getOverrideFontType() == null) {
            if (this.getBaseFont() == null) {
                return null;
            }
            return this.getBaseFont().getFontType();
        }
        return this.getOverrideFontType();
    }

    public Encoding getOverrideEncoding() {
        return this.overrideEncoding;
    }

    public String getOverrideFontFamilyName() {
        return this.overrideFontFamilyName;
    }

    public String getOverrideFontName() {
        return this.overrideFontName;
    }

    public PDFontStyle getOverrideFontStyle() {
        return this.overrideFontStyle;
    }

    public String getOverrideFontType() {
        return this.overrideFontType;
    }

    public void setOverrideEncoding(Encoding overrideEncoding) {
        this.overrideEncoding = overrideEncoding;
    }

    public void setOverrideFontFamilyName(String overrideFontFamilyName) {
        this.overrideFontFamilyName = overrideFontFamilyName;
    }

    public void setOverrideFontName(String overrideFontName) {
        this.overrideFontName = overrideFontName;
    }

    public void setOverrideFontStyle(PDFontStyle overrideFontStyle) {
        this.overrideFontStyle = overrideFontStyle;
    }

    public void setOverrideFontType(String overrideFontType) {
        this.overrideFontType = overrideFontType;
    }
}

