/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.hybrid.image;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsContext;
import de.intarsys.cwt.swt.image.CwtSwtImage;
import de.intarsys.cwt.swt.image.ISwtImage;
import de.intarsys.cwt.swt.image.ImageConverterAwt2Swt;
import de.intarsys.cwt.swt.image.ImageConverterSwt2Awt;
import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class CwtHybridImage
implements IAwtImage,
ISwtImage {
    private CwtAwtImage awtImage;
    private CwtSwtImage swtImage;

    public CwtHybridImage(BufferedImage bufferedImage) {
        this.awtImage = new CwtAwtImage(bufferedImage);
    }

    public CwtHybridImage(CwtAwtImage awtImage) {
        this.awtImage = awtImage;
    }

    public CwtHybridImage(CwtSwtImage swtImage) {
        this.swtImage = swtImage;
    }

    public CwtHybridImage(ImageData imageData) {
        this.swtImage = new CwtSwtImage(imageData);
    }

    protected CwtAwtImage createAwtImage() {
        ImageConverterSwt2Awt converter = new ImageConverterSwt2Awt(this.swtImage.getImageData());
        BufferedImage bufferedImage = converter.getBufferedImage();
        return new CwtAwtImage(bufferedImage);
    }

    protected CwtSwtImage createSwtImage() {
        ImageConverterAwt2Swt converter = new ImageConverterAwt2Swt(this.awtImage.getBufferedImage());
        ImageData imageData = converter.getImageData();
        return new CwtSwtImage(imageData);
    }

    protected void drawFromAwt(CwtAwtGraphicsContext graphicsContext, float x, float y) {
        if (this.awtImage == null) {
            this.awtImage = this.createAwtImage();
        }
        graphicsContext.drawImage(this.awtImage, x, y);
    }

    public void drawFromGraphicsContext(IGraphicsContext graphicsContext, float x, float y) {
        if (graphicsContext instanceof CwtSwtGraphicsContext) {
            this.drawFromSwt((CwtSwtGraphicsContext)graphicsContext, x, y);
        } else if (graphicsContext instanceof CwtAwtGraphicsContext) {
            this.drawFromAwt((CwtAwtGraphicsContext)graphicsContext, x, y);
        } else {
            throw new IllegalArgumentException("graphicsContext not supported");
        }
    }

    protected void drawFromSwt(CwtSwtGraphicsContext graphicsContext, float x, float y) {
        if (this.swtImage == null) {
            try {
                this.swtImage = this.createSwtImage();
            }
            catch (RuntimeException e) {
                return;
            }
        }
        CwtSwtGraphicsContext gc = graphicsContext;
        graphicsContext.drawImage(this.swtImage, x, y);
    }

    public BufferedImage getBufferedImage() {
        if (this.awtImage == null) {
            this.awtImage = this.createAwtImage();
        }
        return this.awtImage.getBufferedImage();
    }

    public int getHeight() {
        if (this.swtImage != null) {
            return this.swtImage.getHeight();
        }
        if (this.awtImage != null) {
            return this.awtImage.getHeight();
        }
        return 0;
    }

    public Image getImage(Device device) {
        if (this.swtImage == null) {
            this.swtImage = this.createSwtImage();
        }
        return this.swtImage.getImage(device);
    }

    public ImageData getImageData() {
        if (this.swtImage == null) {
            this.swtImage = this.createSwtImage();
        }
        return this.swtImage.getImageData();
    }

    public int getWidth() {
        if (this.swtImage != null) {
            return this.swtImage.getWidth();
        }
        if (this.awtImage != null) {
            return this.awtImage.getWidth();
        }
        return 0;
    }
}

