/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.paint.AbstractPaint;

public class ColorPaint
extends AbstractPaint {
    private float alphaValue;
    private PDColorSpace pdColorSpace;
    private float[] colorValues;

    protected ColorPaint(ColorPaint colorPaint) {
        this.alphaValue = colorPaint.alphaValue;
        this.colorValues = colorPaint.colorValues;
        this.pdColorSpace = colorPaint.pdColorSpace;
    }

    public ColorPaint(PDColorSpace pdColorSpace) {
        this.pdColorSpace = pdColorSpace;
        this.alphaValue = 1.0f;
    }

    public IPaint copy() {
        return new ColorPaint(this);
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    public float[] getColorValues() {
        return this.colorValues;
    }

    public PDColorSpace getPdColorSpace() {
        return this.pdColorSpace;
    }

    public void setAlphaValue(float value) {
        this.alphaValue = value;
    }

    public void setBackgroundPaintFromGraphicsContext(IGraphicsContext graphicsContext) {
        IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
        adapter.setBackgroundColorPaint(graphicsContext, this);
    }

    public void setColorValues(float[] paramColorValues) {
        this.colorValues = paramColorValues;
    }

    public void setForegroundPaintFromGraphicsContext(IGraphicsContext graphicsContext) {
        IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
        adapter.setForegroundColorPaint(graphicsContext, this);
    }
}

