/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigdecimalmatrix.BigDecimalMatrix;
import org.ujmp.core.datematrix.DateMatrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.UJMPSettings;

public class UJMPFormat
extends Format {
    private static final long serialVersionUID = -557618747324763226L;
    private static UJMPFormat multiLineInstance = new UJMPFormat(true, 10, true);
    private static UJMPFormat singleLineInstance = new UJMPFormat(false, 100, false);
    private NumberFormat defaultNumberFormat = null;
    private NumberFormat exponentialNumberFormat = null;
    private DateFormat dateFormat = null;
    private boolean multiLine = true;
    private boolean usePadding = false;
    private int width = 10;

    public UJMPFormat(boolean multiLine, int width, boolean usePadding) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(UJMPSettings.getLocale());
        symbols.setNaN("NaN");
        symbols.setInfinity("Inf");
        this.defaultNumberFormat = new DecimalFormat("0.0000", symbols);
        this.exponentialNumberFormat = new DecimalFormat("0.000E000", symbols);
        this.dateFormat = new SimpleDateFormat("yyyy-mm-dd");
        this.multiLine = multiLine;
        this.width = width;
        this.usePadding = usePadding;
    }

    public static final UJMPFormat getMultiLineInstance() {
        return multiLineInstance;
    }

    public static final UJMPFormat getSingleLineInstance() {
        return singleLineInstance;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            if (this.usePadding) {
                this.pad(toAppendTo, ' ', this.width);
            }
            return toAppendTo;
        }
        if (obj instanceof String) {
            return this.format((String)obj, toAppendTo, pos);
        }
        if (obj instanceof Matrix) {
            return this.format((Matrix)obj, toAppendTo, pos);
        }
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo, pos);
        }
        if (obj instanceof Number) {
            return this.format((Number)obj, toAppendTo, pos);
        }
        return this.format(String.valueOf(obj), toAppendTo, pos);
    }

    private StringBuffer format(Matrix obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            if (this.usePadding) {
                this.pad(toAppendTo, ' ', this.width);
            }
            return toAppendTo;
        }
        if (obj.isScalar()) {
            Object v = obj.getAsObject(obj.allCoordinates().iterator().next());
            return this.format(v, toAppendTo, pos);
        }
        if (this.multiLine) {
            return this.formatMultiLine(obj, toAppendTo, pos);
        }
        toAppendTo.append("[Matrix]");
        return toAppendTo;
    }

    private StringBuffer format(Date obj, StringBuffer toAppendTo, FieldPosition pos) {
        int length = toAppendTo.length();
        toAppendTo = this.dateFormat.format(obj, toAppendTo, pos);
        length = this.width - (toAppendTo.length() - length);
        if (this.usePadding) {
            this.pad(toAppendTo, ' ', length);
        }
        return toAppendTo;
    }

    private StringBuffer pad(StringBuffer s, char c, int count) {
        int i = 0;
        while (i < count) {
            s.append(c);
            ++i;
        }
        return s;
    }

    private StringBuffer format(String obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj != null && obj.length() > this.width) {
            obj = obj.substring(0, this.width);
        }
        if (obj != null) {
            toAppendTo.append(obj);
            if (this.usePadding) {
                this.pad(toAppendTo, ' ', this.width - obj.length());
            }
            return toAppendTo;
        }
        if (this.usePadding) {
            this.pad(toAppendTo, ' ', this.width);
        }
        return toAppendTo;
    }

    private StringBuffer format(Number obj, StringBuffer toAppendTo, FieldPosition pos) {
        String s = this.defaultNumberFormat.format(obj);
        if (s.length() > this.width) {
            s = this.exponentialNumberFormat.format(obj);
        }
        if (this.usePadding) {
            this.pad(toAppendTo, ' ', this.width - s.length());
        }
        toAppendTo.append(s);
        return toAppendTo;
    }

    private StringBuffer formatMultiLine(Matrix m, StringBuffer toAppendTo, FieldPosition pos) {
        long maxRows = UJMPSettings.getMaxRowsToPrint();
        long maxColumns = UJMPSettings.getMaxColumnsToPrint();
        String EOL = System.getProperty("line.separator");
        long rowCount = m.getRowCount();
        long columnCount = m.getColumnCount();
        long[] cursor = new long[m.getDimensionCount()];
        if (m.getDimensionCount() > 2) {
            toAppendTo.append(m.getDimensionCount());
            toAppendTo.append("D-Matrix [");
            toAppendTo.append(Coordinates.toString('x', m.getSize()));
            toAppendTo.append("]: only two dimensions are printed");
            toAppendTo.append(EOL);
        }
        if (m.getAnnotation() != null) {
            this.format(m.getLabel(), toAppendTo, pos);
            toAppendTo.append("   ");
            int col = 0;
            while ((long)col < columnCount && (long)col < maxColumns) {
                this.format(m.getColumnLabel(col), toAppendTo, pos);
                if ((long)col < columnCount - 1L) {
                    toAppendTo.append(' ');
                }
                ++col;
            }
            toAppendTo.append(EOL);
            this.pad(toAppendTo, '=', this.width);
            toAppendTo.append("   ");
            col = 0;
            while ((long)col < columnCount && (long)col < maxColumns) {
                this.pad(toAppendTo, '-', this.width);
                if ((long)col < columnCount - 1L) {
                    toAppendTo.append(' ');
                }
                ++col;
            }
            toAppendTo.append(EOL);
        }
        cursor[0] = 0L;
        while (cursor[0] < rowCount && cursor[0] < maxRows) {
            if (m.getAnnotation() != null) {
                this.format(m.getRowLabel(cursor[0]), toAppendTo, pos);
                toAppendTo.append(" | ");
            }
            cursor[1] = 0L;
            while (cursor[1] < columnCount && cursor[1] < maxColumns) {
                Object o = m.getAsObject(cursor);
                toAppendTo = o == null && (m instanceof BigDecimalMatrix || m instanceof DateMatrix) ? this.format(Double.NaN, toAppendTo, pos) : this.format(o, toAppendTo, pos);
                if (cursor[1] < columnCount - 1L) {
                    toAppendTo.append(' ');
                }
                cursor[1] = cursor[1] + 1L;
            }
            toAppendTo.append(EOL);
            cursor[0] = cursor[0] + 1L;
        }
        if (rowCount == 0L || columnCount == 0L) {
            toAppendTo.append("[" + rowCount + "x" + columnCount + "]" + EOL);
        } else if (rowCount > UJMPSettings.getMaxRowsToPrint() || columnCount > UJMPSettings.getMaxColumnsToPrint()) {
            toAppendTo.append("[...]");
        }
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        throw new MatrixException("not implemented");
    }
}

