/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.math.MathContext;
import java.util.Locale;

public abstract class UJMPSettings {
    private static double tolerance = 1.0E-12;
    private static int numberOfThreads = 1;
    private static boolean useJBlas = true;
    private static boolean useOjalgo = true;
    private static boolean useEJML = true;
    private static boolean useParallelColt = true;
    private static boolean useMTJ = true;
    private static boolean useCommonsMath = true;
    private static boolean useBlockMatrixMultiply = true;
    private static int defaultBlockSize = 100;
    private static MathContext mathContext = MathContext.DECIMAL128;
    private static long maxRowsToPrint = 100L;
    private static long maxColumnsToPrint = 100L;
    private static long maxToolTipRows = 10L;
    private static long maxToolTipCols = 10L;

    static {
        try {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            UJMPSettings.setLocale(Locale.US);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MathContext getDefaultMathContext() {
        return mathContext;
    }

    public static void setDefaultMathContext(MathContext mc) {
        mathContext = mc;
    }

    public static void initialize() {
        try {
            System.setProperty("file.encoding", "UTF-8");
            System.setProperty("sun.jnu.encoding", "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getNumberOfThreads() {
        return numberOfThreads;
    }

    public static void setNumberOfThreads(int numberOfThreads) {
        UJMPSettings.numberOfThreads = numberOfThreads;
    }

    public static double getTolerance() {
        return tolerance;
    }

    public static void setTolerance(double tolerance) {
        UJMPSettings.tolerance = tolerance;
    }

    public static long getMaxColumnsToPrint() {
        return maxColumnsToPrint;
    }

    public static void setMaxColumnsToPrint(long maxColumnsToPrint) {
        UJMPSettings.maxColumnsToPrint = maxColumnsToPrint;
    }

    public static long getMaxRowsToPrint() {
        return maxRowsToPrint;
    }

    public static void setMaxRowsToPrint(long maxRowsToPrint) {
        UJMPSettings.maxRowsToPrint = maxRowsToPrint;
    }

    public static long getMaxToolTipCols() {
        return maxToolTipCols;
    }

    public static void setMaxToolTipCols(long maxToolTipCols) {
        UJMPSettings.maxToolTipCols = maxToolTipCols;
    }

    public static long getMaxToolTipRows() {
        return maxToolTipRows;
    }

    public static void setMaxToolTipRows(long maxToolTipRows) {
        UJMPSettings.maxToolTipRows = maxToolTipRows;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void setLocale(Locale locale) {
        Locale.setDefault(locale);
    }

    public static void setUseCommonsMath(boolean useCommonsMath) {
        UJMPSettings.useCommonsMath = useCommonsMath;
    }

    public static boolean isUseCommonsMath() {
        return useCommonsMath;
    }

    public static void setUseJBlas(boolean useJBlas) {
        UJMPSettings.useJBlas = useJBlas;
    }

    public static boolean isUseJBlas() {
        return useJBlas;
    }

    public static void setUseOjalgo(boolean useOjalgo) {
        UJMPSettings.useOjalgo = useOjalgo;
    }

    public static boolean isUseOjalgo() {
        return useOjalgo;
    }

    public static void setUseEJML(boolean useEJML) {
        UJMPSettings.useEJML = useEJML;
    }

    public static boolean isUseEJML() {
        return useEJML;
    }

    public static void setUseParallelColt(boolean useParallelColt) {
        UJMPSettings.useParallelColt = useParallelColt;
    }

    public static boolean isUseParallelColt() {
        return useParallelColt;
    }

    public static void setUseMTJ(boolean useMTJ) {
        UJMPSettings.useMTJ = useMTJ;
    }

    public static boolean isUseMTJ() {
        return useMTJ;
    }

    public static boolean isUseBlockMatrixMultiply() {
        return useBlockMatrixMultiply;
    }

    public static void setUseBlockMatrixMultiply(boolean useBlockMatrix) {
        useBlockMatrixMultiply = useBlockMatrix;
    }

    public static int getDefaultBlockSize() {
        return defaultBlockSize;
    }

    public static void setDefaultBlockSize(int defaultBlockSize) {
        UJMPSettings.defaultBlockSize = defaultBlockSize;
    }
}

