/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractTextWriter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;

public class TextFileWriter
extends AbstractTextWriter {
    private static final long serialVersionUID = 2481561390856324348L;
    protected PlaceholderFile m_Directory;
    protected String m_Prefix;
    protected String m_Suffix;
    protected boolean m_IgnoreName;

    @Override
    public String globalInfo() {
        return "Writes the content to a text file.Makes sure that the filename is valid.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "directory", new PlaceholderFile("."));
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("suffix", "suffix", ".txt");
        this.m_OptionManager.add("ignore-name", "ignoreName", false);
    }

    public void setDirectory(PlaceholderFile value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderFile getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to save the outputs in.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix for the output files.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The suffix for the output files.";
    }

    public void setIgnoreName(boolean value) {
        this.m_IgnoreName = value;
        this.reset();
    }

    public boolean getIgnoreName() {
        return this.m_IgnoreName;
    }

    public String ignoreNameTipText() {
        return "If set to true, then the name of the content is ignored for generating the filename (useful when prefix or suffix is based on variables).";
    }

    protected String createFilename(String name) {
        String result = this.m_IgnoreName ? this.getDirectory().getAbsolutePath() + PlaceholderFile.separator + this.getPrefix() + this.getSuffix() : this.getDirectory().getAbsolutePath() + PlaceholderFile.separator + this.getPrefix() + FileUtils.createFilename(name, "_") + this.getSuffix();
        return result;
    }

    @Override
    public String write(String content, String name) {
        String filename = this.createFilename(name);
        if (this.isDebugOn()) {
            this.debug("Filename: " + filename);
        }
        boolean ok = FileUtils.writeToFile(filename, content, false);
        if (this.isDebugOn()) {
            this.debug("Result: " + ok);
        }
        if (ok) {
            return filename;
        }
        return null;
    }
}

