/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.NamedCounter;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.flow.transformer.SetVariable;
import adams.gui.core.TextEditorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;

public class CheckVariableUsage
extends AbstractActorProcessor
implements GraphicalOutputProducingProcessor {
    private static final long serialVersionUID = 737084782888325641L;
    protected NamedCounter m_UsageCount;
    protected NamedCounter m_SetCount;
    protected String m_Warnings;

    @Override
    public String globalInfo() {
        return "Performs a 'soft' check whether variables in use are actually set somewhere in the flow.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsageCount = new NamedCounter();
        this.m_SetCount = new NamedCounter();
        this.m_Warnings = null;
    }

    @Override
    protected void processActor(AbstractActor actor) {
        this.m_UsageCount.clear();
        this.m_SetCount.clear();
        this.m_Warnings = null;
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected void incrementSetCount(VariableName var) {
                CheckVariableUsage.this.m_SetCount.next(var.getValue());
            }

            @Override
            public void handleClassOption(ClassOption option) {
                if (option.isVariableAttached()) {
                    CheckVariableUsage.this.m_UsageCount.next(option.getVariableName());
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option) {
                Object obj = null;
                if (option.isVariableAttached()) {
                    CheckVariableUsage.this.m_UsageCount.next(option.getVariableName());
                } else {
                    if (option.getOptionHandler() instanceof adams.flow.standalone.SetVariable && option.getBaseClass() == VariableName.class) {
                        obj = option.getCurrentValue();
                    }
                    if (option.getOptionHandler() instanceof SetVariable && option.getBaseClass() == VariableName.class) {
                        obj = option.getCurrentValue();
                    }
                    if (obj != null) {
                        this.incrementSetCount((VariableName)obj);
                    }
                }
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }
        });
        Set<String> used = this.m_UsageCount.nameSet();
        Set<String> set = this.m_SetCount.nameSet();
        used.removeAll(set);
        if (used.size() > 0) {
            Vector<String> vars = new Vector<String>(used);
            Collections.sort(vars);
            this.m_Warnings = "The following variables were never set:\n" + Utils.flatten(vars, "\n");
        }
    }

    public String getWarnings() {
        return this.m_Warnings;
    }

    @Override
    public boolean hasGraphicalOutput() {
        return this.m_Warnings != null;
    }

    @Override
    public Component getGraphicalOutput() {
        TextEditorPanel result = new TextEditorPanel();
        result.setPreferredSize(new Dimension(400, 300));
        result.setEditable(false);
        if (this.m_Warnings != null) {
            result.setContent(this.m_Warnings);
        }
        return result;
    }
}

