/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.VariableName;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractForLoop;

public class StorageForLoop
extends AbstractForLoop {
    private static final long serialVersionUID = 5940182514084428795L;
    protected VariableName m_VariableName;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Emulates the following for-loop:\n- positive step size:\n  for (int i = lower; i <= upper; i += step)\n- negative step size:\n  for (int i = upper; i >= lower; i += step)\nIn each iteration, the specified variable gets updated with the current value of the for-loop variable. The output of the for-loop is the specified storage value (in each iteration).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variableName", new VariableName());
        this.m_OptionManager.add("storage", "storageName", new StorageName());
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + " var: ";
        String variable = this.getOptionManager().getVariableForProperty("variableName");
        result = variable != null ? result + variable : result + this.m_VariableName;
        result = result + ", storage: ";
        variable = this.getOptionManager().getVariableForProperty("storageName");
        result = variable != null ? result + variable : result + this.m_StorageName;
        return result;
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable that gets updated with the for-loop value.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage value to forward in each iteration of the loop.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        if (this.isDebugOn()) {
            this.debug("i=" + this.m_Current);
        }
        this.getVariables().set(this.m_VariableName.getValue(), "" + this.m_Current);
        if (this.isDebugOn()) {
            this.debug(this.m_VariableName + "=" + this.m_Current);
        }
        Token result = new Token(this.getStorageHandler().getStorage().get(this.m_StorageName));
        this.m_Current += this.m_LoopStep;
        return result;
    }
}

