/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.flow.source.AbstractArrayProvider;

public class StringConstants
extends AbstractArrayProvider {
    private static final long serialVersionUID = 1751543256903416330L;
    protected BaseString[] m_Strings;

    @Override
    public String globalInfo() {
        return "A source for strings.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("string", "strings", new BaseString[0]);
    }

    @Override
    public String getQuickInfo() {
        if (this.m_Strings != null) {
            if (this.m_Strings.length == 1) {
                return this.m_Strings[0].toString();
            }
            return this.m_Strings.length + " values";
        }
        return null;
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the strings as an array or one by one.";
    }

    public void setStrings(BaseString[] value) {
        this.m_Strings = value;
        this.reset();
    }

    public BaseString[] getStrings() {
        return this.m_Strings;
    }

    public String stringsTipText() {
        return "The strings to provide.";
    }

    @Override
    protected String doExecute() {
        String result = null;
        for (int i = 0; i < this.m_Strings.length; ++i) {
            this.m_Queue.add(this.m_Strings[i].stringValue());
        }
        return result;
    }
}

