/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractReportFileReader<T extends Report>
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -207124154855872209L;
    public static final String BACKUP_REPORTS = "reports";
    protected AbstractReportReader<T> m_Reader;
    protected Vector<T> m_Reports;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", this.getDefaultReader());
    }

    protected abstract AbstractReportReader<T> getDefaultReader();

    public void setReader(AbstractReportReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractReportReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for importing the reports.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("reader");
        if (variable != null) {
            return variable;
        }
        if (this.m_Reader != null) {
            return this.m_Reader.getClass().getName();
        }
        return null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public abstract Class[] generates();

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_REPORTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_REPORTS, this.m_Reports);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_REPORTS)) {
            this.m_Reports = (Vector)state.get(BACKUP_REPORTS);
            state.remove(BACKUP_REPORTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Reports = new Vector();
    }

    @Override
    protected String doExecute() {
        String result = null;
        PlaceholderFile file = new PlaceholderFile((String)this.m_InputToken.getPayload());
        this.m_Reader.setInput(file);
        if (this.isDebugOn()) {
            this.debug("Attempting to load '" + file + "'");
        }
        try {
            this.m_Reports = this.m_Reader.read();
            this.m_Reader.cleanUp();
        }
        catch (Exception e) {
            result = "Error reading '" + file + "': " + e;
            return result;
        }
        return result;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Reports.get(0));
        this.m_Reports.remove(0);
        this.updateProvenance(result);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Reports.size() > 0;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, ((Token)cont).getPayload().getClass()));
        }
    }
}

