/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.optimise.AbstractOptimiser;
import adams.optimise.FitnessFunction;
import adams.optimise.OptData;
import adams.optimise.OptVar;
import java.util.Hashtable;

public class GridSearch
extends AbstractOptimiser {
    private static final long serialVersionUID = 8007183147566682576L;
    protected int m_Iterations;

    @Override
    public String globalInfo() {
        return "Grid Search searches the parameter hyper-grid space. The search is refineable.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("iterations", "iterations", 1000);
    }

    public void setIterations(int value) {
        this.m_Iterations = value;
    }

    public int getIterations() {
        return this.m_Iterations;
    }

    public String iterationsTipText() {
        return "The number of iterations to use.";
    }

    protected void setMin(OptData datadef) {
        for (String var : datadef.getVarNames()) {
            OptVar ov = datadef.getVar(var);
            datadef.set(var, ov.m_min);
        }
    }

    protected void setMax(OptData datadef) {
        for (String var : datadef.getVarNames()) {
            OptVar ov = datadef.getVar(var);
            datadef.set(var, ov.m_max);
        }
    }

    public OptData doGrid(OptData datadef, FitnessFunction fitness) {
        Hashtable<String, Double> stepsize = new Hashtable<String, Double>();
        this.setStepSizes(datadef, stepsize);
        this.setMin(datadef);
        OptData initVals = datadef.getClone();
        this.checkBest(fitness.evaluate(datadef), datadef, fitness);
        boolean cont = true;
        while (cont) {
            cont = false;
            for (String var : datadef.getVarNames()) {
                initVals.set(var, initVals.get(var) + stepsize.get(var));
                if (initVals.get(var) > initVals.getVar((String)var).m_max || stepsize.get(var) == 0.0) {
                    initVals.set(var, initVals.getVar((String)var).m_min);
                    continue;
                }
                cont = true;
                break;
            }
            this.checkBest(fitness.evaluate(initVals), initVals, fitness);
        }
        this.setMax(initVals);
        this.checkBest(fitness.evaluate(initVals), initVals, fitness);
        initVals.cleanUp();
        return this.m_bestv;
    }

    @Override
    public OptData optimise(OptData datadef, FitnessFunction fitness) {
        OptData sofar = this.doGrid(datadef, fitness).getClone();
        return sofar;
    }

    protected void setStepSizes(OptData datadef, Hashtable<String, Double> stepsize) {
        double ss;
        OptVar ov;
        int its = this.getIterations();
        int numps = datadef.getVarNames().size();
        for (String var : datadef.getVarNames()) {
            ov = datadef.getVar(var);
            if (!ov.m_isInteger) continue;
            ss = Math.pow(its, 1.0 / (double)numps);
            double newss = ov.getStepSize((int)ss);
            stepsize.put(var, newss);
            its /= ov.getSteps((int)ss);
            --numps;
        }
        for (String var : datadef.getVarNames()) {
            ov = datadef.getVar(var);
            if (!ov.m_isInteger) {
                ss = Math.pow(its, 1.0 / (double)numps);
                stepsize.put(var, ov.getStepSize((int)ss));
            }
            this.debug(var + ".Stepsize=" + stepsize.get(var));
        }
    }
}

